/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.metrics.reporter;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.dromara.soul.metrics.api.MetricsRegister;
import org.dromara.soul.metrics.entity.Metric;

public final class MetricsReporter {
    private static MetricsRegister metricsRegister;

    public static void register(MetricsRegister metricsRegister) {
        MetricsReporter.metricsRegister = metricsRegister;
    }

    public static void registerMetrics(Collection<Metric> metrics) {
        block5: for (Metric metric : metrics) {
            switch (metric.getType()) {
                case COUNTER: {
                    MetricsReporter.registerCounter(metric.getName(), MetricsReporter.getLabelNames(metric.getLabels()), metric.getDocument());
                    continue block5;
                }
                case GAUGE: {
                    MetricsReporter.registerGauge(metric.getName(), MetricsReporter.getLabelNames(metric.getLabels()), metric.getDocument());
                    continue block5;
                }
                case HISTOGRAM: {
                    MetricsReporter.registerHistogram(metric.getName(), MetricsReporter.getLabelNames(metric.getLabels()), metric.getDocument());
                    continue block5;
                }
            }
            throw new RuntimeException("we not support metric registration for type: " + (Object)((Object)metric.getType()));
        }
    }

    public static void registerCounter(String name, String[] labelNames, String document) {
        if (Objects.nonNull(metricsRegister)) {
            metricsRegister.registerCounter(name, labelNames, document);
        }
    }

    public static void registerCounter(String name, String document) {
        metricsRegister.registerCounter(name, null, document);
    }

    public static void registerGauge(String name, String[] labelNames, String document) {
        metricsRegister.registerGauge(name, labelNames, document);
    }

    public static void registerGauge(String name, String document) {
        metricsRegister.registerGauge(name, null, document);
    }

    public static void registerHistogram(String name, String[] labelNames, String document) {
        metricsRegister.registerHistogram(name, labelNames, document);
    }

    public static void registerHistogram(String name, String document) {
        metricsRegister.registerHistogram(name, null, document);
    }

    public static void counterIncrement(String name, String[] labelValues) {
        metricsRegister.counterIncrement(name, labelValues);
    }

    public static void counterIncrement(String name) {
        MetricsReporter.counterIncrement(name, null);
    }

    public static void counterIncrement(String name, String[] labelValues, long count) {
        metricsRegister.counterIncrement(name, labelValues, count);
    }

    public static void gaugeIncrement(String name, String[] labelValues) {
        metricsRegister.gaugeIncrement(name, labelValues);
    }

    public static void gaugeIncrement(String name) {
        MetricsReporter.gaugeIncrement(name, null);
    }

    public static void gaugeDecrement(String name, String[] labelValues) {
        metricsRegister.gaugeDecrement(name, labelValues);
    }

    public static void gaugeDecrement(String name) {
        MetricsReporter.gaugeDecrement(name, null);
    }

    public static void recordTime(String name, String[] labelValues, long duration) {
        metricsRegister.recordTime(name, labelValues, duration);
    }

    public static void recordTime(String name, long duration) {
        MetricsReporter.recordTime(name, null, duration);
    }

    private static String[] getLabelNames(List<String> labels) {
        return labels.toArray(new String[0]);
    }
}

