/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.plugin.api.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.dromara.soul.common.utils.GsonUtils;

public class BodyParamUtils {
    public static Pair<String[], Object[]> buildSingleParameter(String body, String parameterTypes) {
        Map paramMap = GsonUtils.getInstance().toObjectMap(body);
        for (String key : paramMap.keySet()) {
            Object obj = paramMap.get(key);
            if (obj instanceof JsonObject) {
                paramMap.put(key, GsonUtils.getInstance().convertToMap(obj.toString()));
                continue;
            }
            if (obj instanceof JsonArray) {
                paramMap.put(key, GsonUtils.getInstance().fromList(obj.toString(), Object.class));
                continue;
            }
            paramMap.put(key, obj);
        }
        return new ImmutablePair((Object)new String[]{parameterTypes}, (Object)new Object[]{paramMap});
    }

    public static Pair<String[], Object[]> buildParameters(String body, String parameterTypes) {
        String[] parameter = StringUtils.split((String)parameterTypes, (String)",");
        if (parameter.length == 1 && !BodyParamUtils.isBaseType(parameter[0])) {
            return BodyParamUtils.buildSingleParameter(body, parameterTypes);
        }
        Map paramMap = GsonUtils.getInstance().toObjectMap(body);
        LinkedList<Object> list = new LinkedList<Object>();
        for (String key : paramMap.keySet()) {
            Object obj = paramMap.get(key);
            if (obj instanceof JsonObject) {
                list.add(GsonUtils.getInstance().convertToMap(obj.toString()));
                continue;
            }
            if (obj instanceof JsonArray) {
                list.add(GsonUtils.getInstance().fromList(obj.toString(), Object.class));
                continue;
            }
            list.add(obj);
        }
        Object[] objects = list.toArray();
        return new ImmutablePair((Object)parameter, (Object)objects);
    }

    private static boolean isBaseType(String paramType) {
        return paramType.startsWith("java") || paramType.startsWith("[Ljava");
    }
}

