/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.plugin.contextpath;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.dromara.soul.common.dto.RuleData;
import org.dromara.soul.common.dto.SelectorData;
import org.dromara.soul.common.dto.convert.rule.impl.ContextMappingHandle;
import org.dromara.soul.common.enums.PluginEnum;
import org.dromara.soul.common.enums.RpcTypeEnum;
import org.dromara.soul.common.utils.GsonUtils;
import org.dromara.soul.plugin.api.SoulPluginChain;
import org.dromara.soul.plugin.api.context.SoulContext;
import org.dromara.soul.plugin.api.result.SoulResultEnum;
import org.dromara.soul.plugin.api.result.SoulResultWrap;
import org.dromara.soul.plugin.api.utils.WebFluxResultUtils;
import org.dromara.soul.plugin.base.AbstractSoulPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class ContextPathMappingPlugin
extends AbstractSoulPlugin {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ContextPathMappingPlugin.class);

    protected Mono<Void> doExecute(ServerWebExchange exchange, SoulPluginChain chain, SelectorData selector, RuleData rule) {
        SoulContext soulContext = (SoulContext)exchange.getAttribute("context");
        assert (soulContext != null);
        String handle = rule.getHandle();
        ContextMappingHandle contextMappingHandle = (ContextMappingHandle)GsonUtils.getInstance().fromJson(handle, ContextMappingHandle.class);
        if (Objects.isNull(contextMappingHandle) || StringUtils.isBlank((CharSequence)contextMappingHandle.getContextPath())) {
            log.error("context path mapping rule configuration is null \uff1a{}", (Object)rule);
            return chain.execute(exchange);
        }
        if (!soulContext.getPath().startsWith(contextMappingHandle.getContextPath())) {
            Object error = SoulResultWrap.error((int)SoulResultEnum.CONTEXT_PATH_ERROR.getCode(), (String)SoulResultEnum.CONTEXT_PATH_ERROR.getMsg(), null);
            return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
        }
        this.buildContextPath(soulContext, contextMappingHandle);
        return chain.execute(exchange);
    }

    public int getOrder() {
        return PluginEnum.CONTEXTPATH_MAPPING.getCode();
    }

    public String named() {
        return PluginEnum.CONTEXTPATH_MAPPING.getName();
    }

    public Boolean skip(ServerWebExchange exchange) {
        SoulContext body = (SoulContext)exchange.getAttribute("context");
        return Objects.equals(Objects.requireNonNull(body).getRpcType(), RpcTypeEnum.DUBBO.getName());
    }

    private void buildContextPath(SoulContext context, ContextMappingHandle handle) {
        context.setContextPath(handle.getContextPath());
        context.setModule(handle.getContextPath());
        if (!StringUtils.isBlank((CharSequence)handle.getRealUrl())) {
            log.info("context path mappingPlugin replaced old :{} , real:{}", (Object)context.getRealUrl(), (Object)handle.getRealUrl());
            context.setRealUrl(handle.getRealUrl());
            return;
        }
        Optional<String> optional = Arrays.stream(context.getPath().split(handle.getContextPath())).reduce((first, last) -> last);
        optional.ifPresent(arg_0 -> ((SoulContext)context).setRealUrl(arg_0));
    }
}

