/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.plugin.dubbo.common.response;

import java.util.Objects;
import org.dromara.soul.common.enums.PluginEnum;
import org.dromara.soul.common.enums.RpcTypeEnum;
import org.dromara.soul.common.exception.SoulException;
import org.dromara.soul.common.utils.JsonUtils;
import org.dromara.soul.plugin.api.SoulPlugin;
import org.dromara.soul.plugin.api.SoulPluginChain;
import org.dromara.soul.plugin.api.context.SoulContext;
import org.dromara.soul.plugin.api.result.SoulResultEnum;
import org.dromara.soul.plugin.api.result.SoulResultWrap;
import org.dromara.soul.plugin.api.utils.WebFluxResultUtils;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class DubboResponsePlugin
implements SoulPlugin {
    public Mono<Void> execute(ServerWebExchange exchange, SoulPluginChain chain) {
        return chain.execute(exchange).then(Mono.defer(() -> {
            Object result = exchange.getAttribute("dubbo_rpc_result");
            try {
                if (Objects.isNull(result)) {
                    Object error = SoulResultWrap.error((int)SoulResultEnum.SERVICE_RESULT_ERROR.getCode(), (String)SoulResultEnum.SERVICE_RESULT_ERROR.getMsg(), null);
                    return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
                }
                Object success = SoulResultWrap.success((int)SoulResultEnum.SUCCESS.getCode(), (String)SoulResultEnum.SUCCESS.getMsg(), (Object)JsonUtils.removeClass((Object)result));
                return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)success);
            }
            catch (SoulException e) {
                return Mono.empty();
            }
        }));
    }

    public Boolean skip(ServerWebExchange exchange) {
        SoulContext soulContext = (SoulContext)exchange.getAttribute("context");
        assert (soulContext != null);
        return !Objects.equals(soulContext.getRpcType(), RpcTypeEnum.DUBBO.getName());
    }

    public int getOrder() {
        return PluginEnum.RESPONSE.getCode();
    }

    public String named() {
        return PluginEnum.RESPONSE.getName();
    }
}

