/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.plugin.global;

import org.apache.commons.lang3.StringUtils;
import org.dromara.soul.plugin.api.SoulPlugin;
import org.dromara.soul.plugin.api.SoulPluginChain;
import org.dromara.soul.plugin.api.context.SoulContext;
import org.dromara.soul.plugin.api.context.SoulContextBuilder;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class GlobalPlugin
implements SoulPlugin {
    private SoulContextBuilder builder;

    public GlobalPlugin(SoulContextBuilder builder) {
        this.builder = builder;
    }

    public Mono<Void> execute(ServerWebExchange exchange, SoulPluginChain chain) {
        SoulContext soulContext;
        ServerHttpRequest request = exchange.getRequest();
        HttpHeaders headers = request.getHeaders();
        String upgrade = headers.getFirst("Upgrade");
        if (StringUtils.isBlank((CharSequence)upgrade) || !"websocket".equals(upgrade)) {
            soulContext = this.builder.build(exchange);
        } else {
            MultiValueMap queryParams = request.getQueryParams();
            soulContext = this.transformMap((MultiValueMap<String, String>)queryParams);
        }
        exchange.getAttributes().put("context", soulContext);
        return chain.execute(exchange);
    }

    public int getOrder() {
        return 0;
    }

    private SoulContext transformMap(MultiValueMap<String, String> queryParams) {
        SoulContext soulContext = new SoulContext();
        soulContext.setModule((String)queryParams.getFirst((Object)"module"));
        soulContext.setMethod((String)queryParams.getFirst((Object)"method"));
        soulContext.setRpcType((String)queryParams.getFirst((Object)"rpcType"));
        return soulContext;
    }

    public String named() {
        return "global";
    }
}

