/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.plugin.httpclient.config;

import java.io.IOException;
import java.net.URL;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.boot.web.server.WebServerException;
import org.springframework.util.ResourceUtils;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.tcp.SslProvider;

public class HttpClientProperties {
    private Integer connectTimeout;
    private Duration responseTimeout;
    private Pool pool = new Pool();
    private Proxy proxy = new Proxy();
    private Ssl ssl = new Ssl();
    private boolean wiretap;

    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    public Duration getResponseTimeout() {
        return this.responseTimeout;
    }

    public Pool getPool() {
        return this.pool;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public Ssl getSsl() {
        return this.ssl;
    }

    public boolean isWiretap() {
        return this.wiretap;
    }

    public void setConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setResponseTimeout(Duration responseTimeout) {
        this.responseTimeout = responseTimeout;
    }

    public void setPool(Pool pool) {
        this.pool = pool;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public void setSsl(Ssl ssl) {
        this.ssl = ssl;
    }

    public void setWiretap(boolean wiretap) {
        this.wiretap = wiretap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpClientProperties)) {
            return false;
        }
        HttpClientProperties other = (HttpClientProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$connectTimeout = this.getConnectTimeout();
        Integer other$connectTimeout = other.getConnectTimeout();
        if (this$connectTimeout == null ? other$connectTimeout != null : !((Object)this$connectTimeout).equals(other$connectTimeout)) {
            return false;
        }
        Duration this$responseTimeout = this.getResponseTimeout();
        Duration other$responseTimeout = other.getResponseTimeout();
        if (this$responseTimeout == null ? other$responseTimeout != null : !((Object)this$responseTimeout).equals(other$responseTimeout)) {
            return false;
        }
        Pool this$pool = this.getPool();
        Pool other$pool = other.getPool();
        if (this$pool == null ? other$pool != null : !((Object)this$pool).equals(other$pool)) {
            return false;
        }
        Proxy this$proxy = this.getProxy();
        Proxy other$proxy = other.getProxy();
        if (this$proxy == null ? other$proxy != null : !((Object)this$proxy).equals(other$proxy)) {
            return false;
        }
        Ssl this$ssl = this.getSsl();
        Ssl other$ssl = other.getSsl();
        if (this$ssl == null ? other$ssl != null : !((Object)this$ssl).equals(other$ssl)) {
            return false;
        }
        return this.isWiretap() == other.isWiretap();
    }

    protected boolean canEqual(Object other) {
        return other instanceof HttpClientProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $connectTimeout = this.getConnectTimeout();
        result = result * 59 + ($connectTimeout == null ? 43 : ((Object)$connectTimeout).hashCode());
        Duration $responseTimeout = this.getResponseTimeout();
        result = result * 59 + ($responseTimeout == null ? 43 : ((Object)$responseTimeout).hashCode());
        Pool $pool = this.getPool();
        result = result * 59 + ($pool == null ? 43 : ((Object)$pool).hashCode());
        Proxy $proxy = this.getProxy();
        result = result * 59 + ($proxy == null ? 43 : ((Object)$proxy).hashCode());
        Ssl $ssl = this.getSsl();
        result = result * 59 + ($ssl == null ? 43 : ((Object)$ssl).hashCode());
        result = result * 59 + (this.isWiretap() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "HttpClientProperties(connectTimeout=" + this.getConnectTimeout() + ", responseTimeout=" + this.getResponseTimeout() + ", pool=" + this.getPool() + ", proxy=" + this.getProxy() + ", ssl=" + this.getSsl() + ", wiretap=" + this.isWiretap() + ")";
    }

    public class Ssl {
        private boolean useInsecureTrustManager;
        private List<String> trustedX509Certificates = new ArrayList<String>();
        private Duration handshakeTimeout = Duration.ofMillis(10000L);
        private Duration closeNotifyFlushTimeout = Duration.ofMillis(3000L);
        private Duration closeNotifyReadTimeout = Duration.ZERO;
        private SslProvider.DefaultConfigurationType defaultConfigurationType = SslProvider.DefaultConfigurationType.TCP;

        public X509Certificate[] getTrustedX509CertificatesForTrustManager() {
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                ArrayList<? extends Certificate> allCerts = new ArrayList<Certificate>();
                for (String trustedCert : HttpClientProperties.this.ssl.getTrustedX509Certificates()) {
                    try {
                        URL url = ResourceUtils.getURL((String)trustedCert);
                        Collection<? extends Certificate> certs = certificateFactory.generateCertificates(url.openStream());
                        allCerts.addAll(certs);
                    }
                    catch (IOException e) {
                        throw new WebServerException("Could not load certificate '" + trustedCert + "'", (Throwable)e);
                    }
                }
                return allCerts.toArray(new X509Certificate[allCerts.size()]);
            }
            catch (CertificateException e) {
                throw new WebServerException("Could not load CertificateFactory X.509", (Throwable)e);
            }
        }

        public boolean isUseInsecureTrustManager() {
            return this.useInsecureTrustManager;
        }

        public List<String> getTrustedX509Certificates() {
            return this.trustedX509Certificates;
        }

        public Duration getHandshakeTimeout() {
            return this.handshakeTimeout;
        }

        public Duration getCloseNotifyFlushTimeout() {
            return this.closeNotifyFlushTimeout;
        }

        public Duration getCloseNotifyReadTimeout() {
            return this.closeNotifyReadTimeout;
        }

        public SslProvider.DefaultConfigurationType getDefaultConfigurationType() {
            return this.defaultConfigurationType;
        }

        public void setUseInsecureTrustManager(boolean useInsecureTrustManager) {
            this.useInsecureTrustManager = useInsecureTrustManager;
        }

        public void setTrustedX509Certificates(List<String> trustedX509Certificates) {
            this.trustedX509Certificates = trustedX509Certificates;
        }

        public void setHandshakeTimeout(Duration handshakeTimeout) {
            this.handshakeTimeout = handshakeTimeout;
        }

        public void setCloseNotifyFlushTimeout(Duration closeNotifyFlushTimeout) {
            this.closeNotifyFlushTimeout = closeNotifyFlushTimeout;
        }

        public void setCloseNotifyReadTimeout(Duration closeNotifyReadTimeout) {
            this.closeNotifyReadTimeout = closeNotifyReadTimeout;
        }

        public void setDefaultConfigurationType(SslProvider.DefaultConfigurationType defaultConfigurationType) {
            this.defaultConfigurationType = defaultConfigurationType;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Ssl)) {
                return false;
            }
            Ssl other = (Ssl)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isUseInsecureTrustManager() != other.isUseInsecureTrustManager()) {
                return false;
            }
            List<String> this$trustedX509Certificates = this.getTrustedX509Certificates();
            List<String> other$trustedX509Certificates = other.getTrustedX509Certificates();
            if (this$trustedX509Certificates == null ? other$trustedX509Certificates != null : !((Object)this$trustedX509Certificates).equals(other$trustedX509Certificates)) {
                return false;
            }
            Duration this$handshakeTimeout = this.getHandshakeTimeout();
            Duration other$handshakeTimeout = other.getHandshakeTimeout();
            if (this$handshakeTimeout == null ? other$handshakeTimeout != null : !((Object)this$handshakeTimeout).equals(other$handshakeTimeout)) {
                return false;
            }
            Duration this$closeNotifyFlushTimeout = this.getCloseNotifyFlushTimeout();
            Duration other$closeNotifyFlushTimeout = other.getCloseNotifyFlushTimeout();
            if (this$closeNotifyFlushTimeout == null ? other$closeNotifyFlushTimeout != null : !((Object)this$closeNotifyFlushTimeout).equals(other$closeNotifyFlushTimeout)) {
                return false;
            }
            Duration this$closeNotifyReadTimeout = this.getCloseNotifyReadTimeout();
            Duration other$closeNotifyReadTimeout = other.getCloseNotifyReadTimeout();
            if (this$closeNotifyReadTimeout == null ? other$closeNotifyReadTimeout != null : !((Object)this$closeNotifyReadTimeout).equals(other$closeNotifyReadTimeout)) {
                return false;
            }
            SslProvider.DefaultConfigurationType this$defaultConfigurationType = this.getDefaultConfigurationType();
            SslProvider.DefaultConfigurationType other$defaultConfigurationType = other.getDefaultConfigurationType();
            return !(this$defaultConfigurationType == null ? other$defaultConfigurationType != null : !this$defaultConfigurationType.equals(other$defaultConfigurationType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Ssl;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isUseInsecureTrustManager() ? 79 : 97);
            List<String> $trustedX509Certificates = this.getTrustedX509Certificates();
            result = result * 59 + ($trustedX509Certificates == null ? 43 : ((Object)$trustedX509Certificates).hashCode());
            Duration $handshakeTimeout = this.getHandshakeTimeout();
            result = result * 59 + ($handshakeTimeout == null ? 43 : ((Object)$handshakeTimeout).hashCode());
            Duration $closeNotifyFlushTimeout = this.getCloseNotifyFlushTimeout();
            result = result * 59 + ($closeNotifyFlushTimeout == null ? 43 : ((Object)$closeNotifyFlushTimeout).hashCode());
            Duration $closeNotifyReadTimeout = this.getCloseNotifyReadTimeout();
            result = result * 59 + ($closeNotifyReadTimeout == null ? 43 : ((Object)$closeNotifyReadTimeout).hashCode());
            SslProvider.DefaultConfigurationType $defaultConfigurationType = this.getDefaultConfigurationType();
            result = result * 59 + ($defaultConfigurationType == null ? 43 : $defaultConfigurationType.hashCode());
            return result;
        }

        public String toString() {
            return "HttpClientProperties.Ssl(useInsecureTrustManager=" + this.isUseInsecureTrustManager() + ", trustedX509Certificates=" + this.getTrustedX509Certificates() + ", handshakeTimeout=" + this.getHandshakeTimeout() + ", closeNotifyFlushTimeout=" + this.getCloseNotifyFlushTimeout() + ", closeNotifyReadTimeout=" + this.getCloseNotifyReadTimeout() + ", defaultConfigurationType=" + this.getDefaultConfigurationType() + ")";
        }
    }

    public static class Proxy {
        private String host;
        private Integer port;
        private String username;
        private String password;
        private String nonProxyHostsPattern;

        public String getHost() {
            return this.host;
        }

        public Integer getPort() {
            return this.port;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public String getNonProxyHostsPattern() {
            return this.nonProxyHostsPattern;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public void setPort(Integer port) {
            this.port = port;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public void setNonProxyHostsPattern(String nonProxyHostsPattern) {
            this.nonProxyHostsPattern = nonProxyHostsPattern;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Proxy)) {
                return false;
            }
            Proxy other = (Proxy)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$host = this.getHost();
            String other$host = other.getHost();
            if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
                return false;
            }
            Integer this$port = this.getPort();
            Integer other$port = other.getPort();
            if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            String this$password = this.getPassword();
            String other$password = other.getPassword();
            if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
                return false;
            }
            String this$nonProxyHostsPattern = this.getNonProxyHostsPattern();
            String other$nonProxyHostsPattern = other.getNonProxyHostsPattern();
            return !(this$nonProxyHostsPattern == null ? other$nonProxyHostsPattern != null : !this$nonProxyHostsPattern.equals(other$nonProxyHostsPattern));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Proxy;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $host = this.getHost();
            result = result * 59 + ($host == null ? 43 : $host.hashCode());
            Integer $port = this.getPort();
            result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            String $password = this.getPassword();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            String $nonProxyHostsPattern = this.getNonProxyHostsPattern();
            result = result * 59 + ($nonProxyHostsPattern == null ? 43 : $nonProxyHostsPattern.hashCode());
            return result;
        }

        public String toString() {
            return "HttpClientProperties.Proxy(host=" + this.getHost() + ", port=" + this.getPort() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", nonProxyHostsPattern=" + this.getNonProxyHostsPattern() + ")";
        }
    }

    public static class Pool {
        private PoolType type = PoolType.ELASTIC;
        private String name = "proxy";
        private Integer maxConnections = ConnectionProvider.DEFAULT_POOL_MAX_CONNECTIONS;
        private Long acquireTimeout = ConnectionProvider.DEFAULT_POOL_ACQUIRE_TIMEOUT;

        public PoolType getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public Integer getMaxConnections() {
            return this.maxConnections;
        }

        public Long getAcquireTimeout() {
            return this.acquireTimeout;
        }

        public void setType(PoolType type) {
            this.type = type;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setMaxConnections(Integer maxConnections) {
            this.maxConnections = maxConnections;
        }

        public void setAcquireTimeout(Long acquireTimeout) {
            this.acquireTimeout = acquireTimeout;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Pool)) {
                return false;
            }
            Pool other = (Pool)o;
            if (!other.canEqual(this)) {
                return false;
            }
            PoolType this$type = this.getType();
            PoolType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Integer this$maxConnections = this.getMaxConnections();
            Integer other$maxConnections = other.getMaxConnections();
            if (this$maxConnections == null ? other$maxConnections != null : !((Object)this$maxConnections).equals(other$maxConnections)) {
                return false;
            }
            Long this$acquireTimeout = this.getAcquireTimeout();
            Long other$acquireTimeout = other.getAcquireTimeout();
            return !(this$acquireTimeout == null ? other$acquireTimeout != null : !((Object)this$acquireTimeout).equals(other$acquireTimeout));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Pool;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            PoolType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Integer $maxConnections = this.getMaxConnections();
            result = result * 59 + ($maxConnections == null ? 43 : ((Object)$maxConnections).hashCode());
            Long $acquireTimeout = this.getAcquireTimeout();
            result = result * 59 + ($acquireTimeout == null ? 43 : ((Object)$acquireTimeout).hashCode());
            return result;
        }

        public String toString() {
            return "HttpClientProperties.Pool(type=" + (Object)((Object)this.getType()) + ", name=" + this.getName() + ", maxConnections=" + this.getMaxConnections() + ", acquireTimeout=" + this.getAcquireTimeout() + ")";
        }

        public static enum PoolType {
            ELASTIC,
            FIXED,
            DISABLED;

        }
    }
}

