/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.plugin.httpclient.response;

import java.util.Map;
import java.util.Objects;
import org.dromara.soul.common.enums.PluginEnum;
import org.dromara.soul.common.enums.RpcTypeEnum;
import org.dromara.soul.plugin.api.SoulPlugin;
import org.dromara.soul.plugin.api.SoulPluginChain;
import org.dromara.soul.plugin.api.context.SoulContext;
import org.dromara.soul.plugin.api.result.SoulResultEnum;
import org.dromara.soul.plugin.base.utils.SoulResultWarp;
import org.dromara.soul.plugin.base.utils.WebFluxResultUtils;
import org.reactivestreams.Publisher;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.reactive.function.BodyExtractors;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class WebClientResponsePlugin
implements SoulPlugin {
    public Mono<Void> execute(ServerWebExchange exchange, SoulPluginChain chain) {
        return chain.execute(exchange).then(Mono.defer(() -> {
            ServerHttpResponse response = exchange.getResponse();
            ClientResponse clientResponse = (ClientResponse)exchange.getAttribute("webHandlerClientResponse");
            if (Objects.isNull(clientResponse) || response.getStatusCode() == HttpStatus.BAD_GATEWAY || response.getStatusCode() == HttpStatus.INTERNAL_SERVER_ERROR) {
                Object error = SoulResultWarp.error((int)SoulResultEnum.SERVICE_RESULT_ERROR.getCode(), (String)SoulResultEnum.SERVICE_RESULT_ERROR.getMsg(), null);
                return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
            }
            if (response.getStatusCode() == HttpStatus.GATEWAY_TIMEOUT) {
                Object error = SoulResultWarp.error((int)SoulResultEnum.SERVICE_TIMEOUT.getCode(), (String)SoulResultEnum.SERVICE_TIMEOUT.getMsg(), null);
                return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
            }
            response.setStatusCode(clientResponse.statusCode());
            response.getCookies().putAll((Map)clientResponse.cookies());
            response.getHeaders().putAll((Map)clientResponse.headers().asHttpHeaders());
            return response.writeWith((Publisher)clientResponse.body(BodyExtractors.toDataBuffers()));
        }));
    }

    public int getOrder() {
        return PluginEnum.RESPONSE.getCode();
    }

    public Boolean skip(ServerWebExchange exchange) {
        SoulContext soulContext = (SoulContext)exchange.getAttribute("context");
        assert (soulContext != null);
        return !Objects.equals(RpcTypeEnum.HTTP.getName(), soulContext.getRpcType()) && !Objects.equals(RpcTypeEnum.SPRING_CLOUD.getName(), soulContext.getRpcType());
    }

    public String named() {
        return PluginEnum.RESPONSE.getName();
    }
}

