/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.plugin.httpclient;

import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.dromara.soul.common.enums.PluginEnum;
import org.dromara.soul.common.enums.ResultEnum;
import org.dromara.soul.common.enums.RpcTypeEnum;
import org.dromara.soul.plugin.api.SoulPlugin;
import org.dromara.soul.plugin.api.SoulPluginChain;
import org.dromara.soul.plugin.api.context.SoulContext;
import org.dromara.soul.plugin.api.result.SoulResultEnum;
import org.dromara.soul.plugin.base.utils.SoulResultWarp;
import org.dromara.soul.plugin.base.utils.WebFluxResultUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class WebClientPlugin
implements SoulPlugin {
    private static final Logger log = LoggerFactory.getLogger(WebClientPlugin.class);
    private final WebClient webClient;

    public WebClientPlugin(WebClient webClient) {
        this.webClient = webClient;
    }

    public Mono<Void> execute(ServerWebExchange exchange, SoulPluginChain chain) {
        SoulContext soulContext = (SoulContext)exchange.getAttribute("context");
        assert (soulContext != null);
        String urlPath = (String)exchange.getAttribute("httpUrl");
        if (StringUtils.isEmpty((CharSequence)urlPath)) {
            Object error = SoulResultWarp.error((int)SoulResultEnum.CANNOT_FIND_URL.getCode(), (String)SoulResultEnum.CANNOT_FIND_URL.getMsg(), null);
            return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
        }
        long timeout = (Long)Optional.ofNullable(exchange.getAttribute("httpTimeOut")).orElse(3000L);
        log.info("you request,The resulting urlPath is :{}", (Object)urlPath);
        HttpMethod method = HttpMethod.valueOf((String)exchange.getRequest().getMethodValue());
        WebClient.RequestBodySpec requestBodySpec = (WebClient.RequestBodySpec)this.webClient.method(method).uri(urlPath, new Object[0]);
        return this.handleRequestBody(requestBodySpec, exchange, timeout, chain);
    }

    public int getOrder() {
        return PluginEnum.DIVIDE.getCode() + 1;
    }

    public String named() {
        return "webClient";
    }

    public Boolean skip(ServerWebExchange exchange) {
        SoulContext soulContext = (SoulContext)exchange.getAttribute("context");
        assert (soulContext != null);
        return !Objects.equals(RpcTypeEnum.HTTP.getName(), soulContext.getRpcType()) && !Objects.equals(RpcTypeEnum.SPRING_CLOUD.getName(), soulContext.getRpcType());
    }

    private MediaType buildMediaType(ServerWebExchange exchange) {
        return MediaType.valueOf((String)Optional.ofNullable(exchange.getRequest().getHeaders().getFirst("Content-Type")).orElse("application/json"));
    }

    private Mono<Void> handleRequestBody(WebClient.RequestBodySpec requestBodySpec, ServerWebExchange exchange, long timeout, SoulPluginChain chain) {
        return ((WebClient.RequestBodySpec)requestBodySpec.headers(httpHeaders -> {
            httpHeaders.addAll((MultiValueMap)exchange.getRequest().getHeaders());
            httpHeaders.remove((Object)"Host");
        })).contentType(this.buildMediaType(exchange)).body(BodyInserters.fromDataBuffers((Publisher)exchange.getRequest().getBody())).exchange().doOnError(e -> log.error(e.getMessage())).timeout(Duration.ofMillis(timeout)).flatMap(e -> this.doNext((ClientResponse)e, exchange, chain));
    }

    private Mono<Void> doNext(ClientResponse res, ServerWebExchange exchange, SoulPluginChain chain) {
        if (res.statusCode().is2xxSuccessful()) {
            exchange.getAttributes().put("webHandlerClientResponseResultType", ResultEnum.SUCCESS.getName());
        } else {
            exchange.getAttributes().put("webHandlerClientResponseResultType", ResultEnum.ERROR.getName());
        }
        exchange.getAttributes().put("webHandlerClientResponse", res);
        return chain.execute(exchange);
    }
}

