/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.plugin.httpclient.response;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.dromara.soul.common.enums.RpcTypeEnum;
import org.dromara.soul.plugin.api.SoulPlugin;
import org.dromara.soul.plugin.api.SoulPluginChain;
import org.dromara.soul.plugin.api.context.SoulContext;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;

public class NettyClientResponsePlugin
implements SoulPlugin {
    private static final Logger log = LoggerFactory.getLogger(NettyClientResponsePlugin.class);
    private final List<MediaType> streamingMediaTypes = Arrays.asList(MediaType.TEXT_EVENT_STREAM, MediaType.APPLICATION_STREAM_JSON);

    public Mono<Void> execute(ServerWebExchange exchange, SoulPluginChain chain) {
        return Mono.defer(() -> {
            Connection connection = (Connection)exchange.getAttribute("nettyClientResponseConnection");
            if (connection == null) {
                return Mono.empty();
            }
            if (log.isTraceEnabled()) {
                log.trace("NettyWriteResponseFilter start inbound: " + connection.channel().id().asShortText() + ", outbound: " + exchange.getLogPrefix());
            }
            ServerHttpResponse response = exchange.getResponse();
            NettyDataBufferFactory factory = (NettyDataBufferFactory)response.bufferFactory();
            Flux body = connection.inbound().receive().retain().map(arg_0 -> ((NettyDataBufferFactory)factory).wrap(arg_0));
            MediaType contentType = response.getHeaders().getContentType();
            return this.isStreamingMediaType(contentType) ? response.writeAndFlushWith((Publisher)body.map(Flux::just)) : response.writeWith((Publisher)body);
        }).then(chain.execute(exchange).doOnError(throwable -> this.cleanup(exchange))).doOnCancel(() -> this.cleanup(exchange));
    }

    public int getOrder() {
        return 100;
    }

    public String named() {
        return "NettyWriteResponse";
    }

    public Boolean skip(ServerWebExchange exchange) {
        SoulContext soulContext = (SoulContext)exchange.getAttribute("context");
        assert (soulContext != null);
        return !Objects.equals(RpcTypeEnum.HTTP.getName(), soulContext.getRpcType()) && !Objects.equals(RpcTypeEnum.SPRING_CLOUD.getName(), soulContext.getRpcType());
    }

    private void cleanup(ServerWebExchange exchange) {
        Connection connection = (Connection)exchange.getAttribute("nettyClientResponseConnection");
        if (connection != null) {
            connection.dispose();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isStreamingMediaType(@Nullable MediaType contentType) {
        if (contentType == null) return false;
        if (!this.streamingMediaTypes.stream().anyMatch(arg_0 -> ((MediaType)contentType).isCompatibleWith(arg_0))) return false;
        return true;
    }
}

