/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.plugin.hystrix.command;

import com.netflix.hystrix.HystrixCommand;
import java.net.URI;
import org.dromara.soul.plugin.api.SoulPluginChain;
import org.dromara.soul.plugin.base.utils.UriUtils;
import org.dromara.soul.plugin.hystrix.command.Command;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import rx.Observable;
import rx.RxReactiveStreams;

public class HystrixCommandOnThread
extends HystrixCommand<Mono<Void>>
implements Command {
    private static final Logger LOGGER = LoggerFactory.getLogger(HystrixCommandOnThread.class);
    private final ServerWebExchange exchange;
    private final SoulPluginChain chain;
    private final URI callBackUri;

    public HystrixCommandOnThread(HystrixCommand.Setter setter, ServerWebExchange exchange, SoulPluginChain chain, String callBackUri) {
        super(setter);
        this.exchange = exchange;
        this.chain = chain;
        this.callBackUri = UriUtils.createUri((String)callBackUri);
    }

    protected Mono<Void> run() {
        RxReactiveStreams.toObservable((Publisher)this.chain.execute(this.exchange)).toBlocking().subscribe();
        return Mono.empty();
    }

    protected Mono<Void> getFallback() {
        if (this.isFailedExecution()) {
            LOGGER.error("hystrix execute have error: ", this.getExecutionException());
        }
        Throwable exception = this.getExecutionException();
        return this.doFallback(this.exchange, exception);
    }

    @Override
    public Observable<Void> fetchObservable() {
        return RxReactiveStreams.toObservable((Publisher)((Publisher)this.execute()));
    }

    @Override
    public URI getCallBackUri() {
        return this.callBackUri;
    }
}

