/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.plugin.hystrix.command;

import com.netflix.hystrix.HystrixObservableCommand;
import java.net.URI;
import lombok.Generated;
import org.dromara.soul.plugin.api.SoulPluginChain;
import org.dromara.soul.plugin.base.utils.UriUtils;
import org.dromara.soul.plugin.hystrix.command.Command;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import rx.Observable;
import rx.RxReactiveStreams;

public class HystrixCommand
extends HystrixObservableCommand<Void>
implements Command {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HystrixCommand.class);
    private final ServerWebExchange exchange;
    private final SoulPluginChain chain;
    private final URI callBackUri;

    public HystrixCommand(HystrixObservableCommand.Setter setter, ServerWebExchange exchange, SoulPluginChain chain, String callBackUri) {
        super(setter);
        this.exchange = exchange;
        this.chain = chain;
        this.callBackUri = UriUtils.createUri((String)callBackUri);
    }

    protected Observable<Void> construct() {
        return RxReactiveStreams.toObservable((Publisher)this.chain.execute(this.exchange));
    }

    protected Observable<Void> resumeWithFallback() {
        return RxReactiveStreams.toObservable(this.doFallback());
    }

    private Mono<Void> doFallback() {
        if (this.isFailedExecution()) {
            log.error("hystrix execute have error: ", this.getExecutionException());
        }
        Throwable exception = this.getExecutionException();
        return this.doFallback(this.exchange, exception);
    }

    @Override
    public Observable<Void> fetchObservable() {
        return this.toObservable();
    }

    @Override
    public URI getCallBackUri() {
        return this.callBackUri;
    }
}

