/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.plugin.monitor.handler;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.dromara.soul.common.dto.PluginData;
import org.dromara.soul.common.enums.PluginEnum;
import org.dromara.soul.common.utils.GsonUtils;
import org.dromara.soul.metrics.config.MetricsConfig;
import org.dromara.soul.metrics.facade.MetricsTrackerFacade;
import org.dromara.soul.plugin.base.handler.PluginDataHandler;
import org.dromara.soul.plugin.base.utils.Singleton;

public class MonitorPluginDataHandler
implements PluginDataHandler {
    public void handlerPlugin(PluginData pluginData) {
        if (Objects.nonNull(pluginData) && pluginData.getEnabled().booleanValue()) {
            MetricsConfig monitorConfig = (MetricsConfig)GsonUtils.getInstance().fromJson(pluginData.getConfig(), MetricsConfig.class);
            if (!this.checkConfig(monitorConfig)) {
                return;
            }
            if (!MetricsTrackerFacade.getInstance().isEnabled()) {
                this.start(monitorConfig);
            } else if (!monitorConfig.equals(Singleton.INST.get(MetricsConfig.class))) {
                this.restart(monitorConfig);
            }
        } else {
            this.stop();
        }
    }

    public String pluginNamed() {
        return PluginEnum.MONITOR.getName();
    }

    private boolean checkConfig(MetricsConfig monitorConfig) {
        return Objects.nonNull(monitorConfig) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{monitorConfig.getHost()}) && Objects.nonNull(monitorConfig.getPort()) && Objects.nonNull(monitorConfig.getAsync());
    }

    private void restart(MetricsConfig monitorConfig) {
        this.stop();
        this.start(monitorConfig);
    }

    private void start(MetricsConfig monitorConfig) {
        MetricsTrackerFacade.getInstance().start(monitorConfig);
        Singleton.INST.single(MetricsConfig.class, (Object)monitorConfig);
    }

    private void stop() {
        MetricsTrackerFacade.getInstance().stop();
    }
}

