/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.plugin.monitor;

import org.dromara.soul.common.dto.RuleData;
import org.dromara.soul.common.dto.SelectorData;
import org.dromara.soul.common.enums.PluginEnum;
import org.dromara.soul.metrics.api.MetricsRegister;
import org.dromara.soul.metrics.prometheus.register.PrometheusMetricsRegister;
import org.dromara.soul.metrics.reporter.MetricsReporter;
import org.dromara.soul.plugin.api.SoulPluginChain;
import org.dromara.soul.plugin.base.AbstractSoulPlugin;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class MonitorPlugin
extends AbstractSoulPlugin {
    private static final String REQUEST_TOTAL = "request_total";
    private static final String HTTP_REQUEST_TOTAL = "http_request_total";

    protected Mono<Void> doExecute(ServerWebExchange exchange, SoulPluginChain chain, SelectorData selector, RuleData rule) {
        MetricsReporter.counterIncrement((String)REQUEST_TOTAL);
        MetricsReporter.counterIncrement((String)HTTP_REQUEST_TOTAL, (String[])new String[]{exchange.getRequest().getURI().getPath(), exchange.getRequest().getMethodValue()});
        return chain.execute(exchange);
    }

    public int getOrder() {
        return PluginEnum.MONITOR.getCode();
    }

    public String named() {
        return PluginEnum.MONITOR.getName();
    }

    static {
        MetricsReporter.register((MetricsRegister)new PrometheusMetricsRegister());
        MetricsReporter.registerCounter((String)REQUEST_TOTAL, (String)"soul request total count");
        MetricsReporter.registerCounter((String)HTTP_REQUEST_TOTAL, (String[])new String[]{"path", "type"}, (String)"soul http request type total count");
    }
}

