/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.plugin.redirect;

import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.dromara.soul.common.dto.RuleData;
import org.dromara.soul.common.dto.SelectorData;
import org.dromara.soul.common.dto.convert.RedirectHandle;
import org.dromara.soul.common.enums.PluginEnum;
import org.dromara.soul.common.utils.GsonUtils;
import org.dromara.soul.plugin.api.SoulPluginChain;
import org.dromara.soul.plugin.base.AbstractSoulPlugin;
import org.dromara.soul.plugin.base.utils.UriUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.reactive.DispatcherHandler;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class RedirectPlugin
extends AbstractSoulPlugin {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RedirectPlugin.class);
    public static final String ROOT_PATH_PREFIX = "/";
    private final DispatcherHandler dispatcherHandler;

    public RedirectPlugin(DispatcherHandler dispatcherHandler) {
        this.dispatcherHandler = dispatcherHandler;
    }

    public int getOrder() {
        return PluginEnum.REDIRECT.getCode();
    }

    public String named() {
        return PluginEnum.REDIRECT.getName();
    }

    protected Mono<Void> doExecute(ServerWebExchange exchange, SoulPluginChain chain, SelectorData selector, RuleData rule) {
        String handle = rule.getHandle();
        RedirectHandle redirectHandle = (RedirectHandle)GsonUtils.getInstance().fromJson(handle, RedirectHandle.class);
        if (Objects.isNull(redirectHandle) || StringUtils.isBlank((CharSequence)redirectHandle.getRedirectURI())) {
            log.error("uri redirect rule can not configuration: {}", (Object)handle);
            return chain.execute(exchange);
        }
        if (redirectHandle.getRedirectURI().startsWith(ROOT_PATH_PREFIX)) {
            ServerHttpRequest request = exchange.getRequest().mutate().uri(Objects.requireNonNull(UriUtils.createUri((String)redirectHandle.getRedirectURI()))).build();
            ServerWebExchange mutated = exchange.mutate().request(request).build();
            return this.dispatcherHandler.handle(mutated);
        }
        ServerHttpResponse response = exchange.getResponse();
        response.setStatusCode(HttpStatus.PERMANENT_REDIRECT);
        response.getHeaders().add("Location", redirectHandle.getRedirectURI());
        return response.setComplete();
    }
}

