/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.plugin.resilience4j;

import java.util.function.Function;
import org.dromara.soul.common.dto.RuleData;
import org.dromara.soul.common.dto.SelectorData;
import org.dromara.soul.common.dto.convert.Resilience4JHandle;
import org.dromara.soul.common.enums.PluginEnum;
import org.dromara.soul.common.utils.GsonUtils;
import org.dromara.soul.plugin.api.SoulPluginChain;
import org.dromara.soul.plugin.api.context.SoulContext;
import org.dromara.soul.plugin.base.AbstractSoulPlugin;
import org.dromara.soul.plugin.resilience4j.build.Resilience4JBuilder;
import org.dromara.soul.plugin.resilience4j.conf.Resilience4JConf;
import org.dromara.soul.plugin.resilience4j.executor.CombinedExecutor;
import org.dromara.soul.plugin.resilience4j.executor.Executor;
import org.dromara.soul.plugin.resilience4j.executor.RateLimiterExecutor;
import org.springframework.http.HttpStatus;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class Resilience4JPlugin
extends AbstractSoulPlugin {
    private final CombinedExecutor combinedExecutor;
    private final RateLimiterExecutor ratelimiterExecutor;

    public Resilience4JPlugin(CombinedExecutor combinedExecutor, RateLimiterExecutor ratelimiterExecutor) {
        this.combinedExecutor = combinedExecutor;
        this.ratelimiterExecutor = ratelimiterExecutor;
    }

    protected Mono<Void> doExecute(ServerWebExchange exchange, SoulPluginChain chain, SelectorData selector, RuleData rule) {
        SoulContext soulContext = (SoulContext)exchange.getAttribute("context");
        assert (soulContext != null);
        Resilience4JHandle resilience4JHandle = (Resilience4JHandle)GsonUtils.getGson().fromJson(rule.getHandle(), Resilience4JHandle.class);
        resilience4JHandle.checkData(resilience4JHandle);
        if (resilience4JHandle.getCircuitEnable() == 1) {
            return this.combined(exchange, chain, rule);
        }
        return this.rateLimiter(exchange, chain, rule);
    }

    private Mono<Void> rateLimiter(ServerWebExchange exchange, SoulPluginChain chain, RuleData rule) {
        return this.ratelimiterExecutor.run(chain.execute(exchange), this.fallback(this.ratelimiterExecutor, exchange, null), Resilience4JBuilder.build(rule)).onErrorResume(throwable -> this.ratelimiterExecutor.withoutFallback(exchange, (Throwable)throwable));
    }

    private Mono<Void> combined(ServerWebExchange exchange, SoulPluginChain chain, RuleData rule) {
        Resilience4JConf conf = Resilience4JBuilder.build(rule);
        return this.combinedExecutor.run(chain.execute(exchange).doOnSuccess(v -> {
            HttpStatus status = exchange.getResponse().getStatusCode();
            if (status == null || !status.is2xxSuccessful()) {
                exchange.getResponse().setStatusCode(null);
                throw new CircuitBreakerStatusCodeException(status == null ? HttpStatus.INTERNAL_SERVER_ERROR : status);
            }
        }), this.fallback(this.combinedExecutor, exchange, conf.getFallBackUri()), conf);
    }

    private Function<Throwable, Mono<Void>> fallback(Executor executor, ServerWebExchange exchange, String uri) {
        return throwable -> executor.fallback(exchange, uri, (Throwable)throwable);
    }

    public int getOrder() {
        return PluginEnum.RESILIENCE4J.getCode();
    }

    public String named() {
        return PluginEnum.RESILIENCE4J.getName();
    }

    public static class CircuitBreakerStatusCodeException
    extends HttpStatusCodeException {
        public CircuitBreakerStatusCodeException(HttpStatus statusCode) {
            super(statusCode);
        }
    }
}

