/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.plugin.resilience4j.build;

import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.core.IntervalFunction;
import io.github.resilience4j.ratelimiter.RateLimiterConfig;
import io.github.resilience4j.timelimiter.TimeLimiterConfig;
import java.time.Duration;
import org.dromara.soul.common.dto.RuleData;
import org.dromara.soul.common.dto.convert.Resilience4JHandle;
import org.dromara.soul.common.utils.GsonUtils;
import org.dromara.soul.plugin.resilience4j.conf.Resilience4JConf;
import org.dromara.soul.plugin.resilience4j.handler.Resilience4JHandler;

public class Resilience4JBuilder {
    public static Resilience4JConf build(RuleData ruleData) {
        Resilience4JHandle handle = (Resilience4JHandle)GsonUtils.getGson().fromJson(ruleData.getHandle(), Resilience4JHandle.class);
        handle.checkData(handle);
        CircuitBreakerConfig circuitBreakerConfig = null;
        if (handle.getCircuitEnable() == 1) {
            circuitBreakerConfig = CircuitBreakerConfig.custom().recordExceptions(new Class[]{Throwable.class, Exception.class}).failureRateThreshold(handle.getFailureRateThreshold()).automaticTransitionFromOpenToHalfOpenEnabled(handle.getAutomaticTransitionFromOpenToHalfOpenEnabled().booleanValue()).slidingWindow(handle.getSlidingWindowSize(), handle.getMinimumNumberOfCalls(), handle.getSlidingWindowType() == 0 ? CircuitBreakerConfig.SlidingWindowType.COUNT_BASED : CircuitBreakerConfig.SlidingWindowType.TIME_BASED).waitIntervalFunctionInOpenState(IntervalFunction.of((Duration)Duration.ofSeconds(handle.getWaitIntervalFunctionInOpenState() / 1000))).permittedNumberOfCallsInHalfOpenState(handle.getPermittedNumberOfCallsInHalfOpenState()).build();
        }
        TimeLimiterConfig timeLimiterConfig = TimeLimiterConfig.custom().timeoutDuration(Duration.ofSeconds(handle.getTimeoutDuration() / 1000L)).build();
        RateLimiterConfig rateLimiterConfig = RateLimiterConfig.custom().limitForPeriod(handle.getLimitForPeriod()).timeoutDuration(Duration.ofSeconds(handle.getTimeoutDurationRate() / 1000)).limitRefreshPeriod(Duration.ofNanos(handle.getLimitRefreshPeriod() * 1000000)).build();
        return new Resilience4JConf(Resilience4JHandler.getResourceName(ruleData), handle.getFallbackUri(), rateLimiterConfig, timeLimiterConfig, circuitBreakerConfig);
    }
}

