/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.plugin.resilience4j.executor;

import io.github.resilience4j.circuitbreaker.CallNotPermittedException;
import io.github.resilience4j.ratelimiter.RequestNotPermitted;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.dromara.soul.plugin.api.result.SoulResultEnum;
import org.dromara.soul.plugin.api.result.SoulResultWrap;
import org.dromara.soul.plugin.api.utils.SpringBeanUtils;
import org.dromara.soul.plugin.api.utils.WebFluxResultUtils;
import org.dromara.soul.plugin.base.utils.UriUtils;
import org.dromara.soul.plugin.resilience4j.Resilience4JPlugin;
import org.dromara.soul.plugin.resilience4j.conf.Resilience4JConf;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.reactive.DispatcherHandler;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public interface Executor {
    public <T> Mono<T> run(Mono<T> var1, Function<Throwable, Mono<T>> var2, Resilience4JConf var3);

    default public Mono<Void> fallback(ServerWebExchange exchange, String uri, Throwable t) {
        if (StringUtils.isBlank((CharSequence)uri)) {
            return this.withoutFallback(exchange, t);
        }
        DispatcherHandler dispatcherHandler = (DispatcherHandler)SpringBeanUtils.getInstance().getBean(DispatcherHandler.class);
        ServerHttpRequest request = exchange.getRequest().mutate().uri(Objects.requireNonNull(UriUtils.createUri((String)uri))).build();
        ServerWebExchange mutated = exchange.mutate().request(request).build();
        return dispatcherHandler.handle(mutated);
    }

    default public Mono<Void> withoutFallback(ServerWebExchange exchange, Throwable throwable) {
        Object error;
        if (throwable instanceof TimeoutException) {
            exchange.getResponse().setStatusCode(HttpStatus.GATEWAY_TIMEOUT);
            error = SoulResultWrap.error((int)SoulResultEnum.SERVICE_TIMEOUT.getCode(), (String)SoulResultEnum.SERVICE_TIMEOUT.getMsg(), null);
        } else {
            if (throwable instanceof Resilience4JPlugin.CircuitBreakerStatusCodeException) {
                return Mono.error((Throwable)throwable);
            }
            if (throwable instanceof CallNotPermittedException) {
                exchange.getResponse().setStatusCode(HttpStatus.INTERNAL_SERVER_ERROR);
                error = SoulResultWrap.error((int)SoulResultEnum.SERVICE_RESULT_ERROR.getCode(), (String)SoulResultEnum.SERVICE_RESULT_ERROR.getMsg(), null);
            } else if (throwable instanceof RequestNotPermitted) {
                exchange.getResponse().setStatusCode(HttpStatus.TOO_MANY_REQUESTS);
                error = SoulResultWrap.error((int)SoulResultEnum.TOO_MANY_REQUESTS.getCode(), (String)SoulResultEnum.TOO_MANY_REQUESTS.getMsg(), null);
            } else {
                exchange.getResponse().setStatusCode(HttpStatus.INTERNAL_SERVER_ERROR);
                error = SoulResultWrap.error((int)SoulResultEnum.SERVICE_RESULT_ERROR.getCode(), (String)SoulResultEnum.SERVICE_RESULT_ERROR.getMsg(), null);
            }
        }
        return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
    }

    default public Mono<Void> error(ServerWebExchange exchange) {
        exchange.getResponse().setStatusCode(HttpStatus.INTERNAL_SERVER_ERROR);
        Object error = SoulResultWrap.error((int)SoulResultEnum.SERVICE_RESULT_ERROR.getCode(), (String)SoulResultEnum.SERVICE_RESULT_ERROR.getMsg(), null);
        return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
    }
}

