/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.plugin.sentinel;

import com.alibaba.csp.sentinel.adapter.reactor.SentinelReactorTransformer;
import java.util.function.Function;
import lombok.Generated;
import org.dromara.soul.common.dto.RuleData;
import org.dromara.soul.common.dto.SelectorData;
import org.dromara.soul.common.dto.convert.SentinelHandle;
import org.dromara.soul.common.enums.PluginEnum;
import org.dromara.soul.common.utils.GsonUtils;
import org.dromara.soul.plugin.api.SoulPluginChain;
import org.dromara.soul.plugin.api.context.SoulContext;
import org.dromara.soul.plugin.base.AbstractSoulPlugin;
import org.dromara.soul.plugin.base.utils.UriUtils;
import org.dromara.soul.plugin.sentinel.fallback.SentinelFallbackHandler;
import org.dromara.soul.plugin.sentinel.handler.SentinelRuleHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class SentinelPlugin
extends AbstractSoulPlugin {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SentinelPlugin.class);
    private final SentinelFallbackHandler sentinelFallbackHandler;

    public SentinelPlugin(SentinelFallbackHandler sentinelFallbackHandler) {
        this.sentinelFallbackHandler = sentinelFallbackHandler;
    }

    protected Mono<Void> doExecute(ServerWebExchange exchange, SoulPluginChain chain, SelectorData selector, RuleData rule) {
        SoulContext soulContext = (SoulContext)exchange.getAttribute("context");
        assert (soulContext != null);
        String resourceName = SentinelRuleHandle.getResourceName(rule);
        SentinelHandle sentinelHandle = (SentinelHandle)GsonUtils.getInstance().fromJson(rule.getHandle(), SentinelHandle.class);
        sentinelHandle.checkData(sentinelHandle);
        return chain.execute(exchange).transform((Function)new SentinelReactorTransformer(resourceName)).doOnSuccess(v -> {
            HttpStatus status = exchange.getResponse().getStatusCode();
            if (status == null || !status.is2xxSuccessful()) {
                exchange.getResponse().setStatusCode(null);
                throw new SentinelFallbackException(status == null ? HttpStatus.INTERNAL_SERVER_ERROR : status);
            }
        }).onErrorResume(throwable -> this.sentinelFallbackHandler.fallback(exchange, UriUtils.createUri((String)sentinelHandle.getFallbackUri()), (Throwable)throwable));
    }

    public String named() {
        return PluginEnum.SENTINEL.getName();
    }

    public int getOrder() {
        return PluginEnum.SENTINEL.getCode();
    }

    public static class SentinelFallbackException
    extends HttpStatusCodeException {
        public SentinelFallbackException(HttpStatus statusCode) {
            super(statusCode);
        }
    }
}

