/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.plugin.sentinel.fallback;

import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeException;
import com.alibaba.csp.sentinel.slots.block.flow.FlowException;
import org.dromara.soul.plugin.api.result.SoulResultEnum;
import org.dromara.soul.plugin.api.result.SoulResultWrap;
import org.dromara.soul.plugin.api.utils.WebFluxResultUtils;
import org.dromara.soul.plugin.base.fallback.FallbackHandler;
import org.springframework.http.HttpStatus;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class SentinelFallbackHandler
implements FallbackHandler {
    public Mono<Void> generateError(ServerWebExchange exchange, Throwable throwable) {
        Object error;
        if (throwable instanceof DegradeException) {
            exchange.getResponse().setStatusCode(HttpStatus.INTERNAL_SERVER_ERROR);
            error = SoulResultWrap.error((int)SoulResultEnum.SERVICE_RESULT_ERROR.getCode(), (String)SoulResultEnum.SERVICE_RESULT_ERROR.getMsg(), null);
        } else if (throwable instanceof FlowException) {
            exchange.getResponse().setStatusCode(HttpStatus.TOO_MANY_REQUESTS);
            error = SoulResultWrap.error((int)SoulResultEnum.TOO_MANY_REQUESTS.getCode(), (String)SoulResultEnum.TOO_MANY_REQUESTS.getMsg(), null);
        } else if (throwable instanceof BlockException) {
            exchange.getResponse().setStatusCode(HttpStatus.TOO_MANY_REQUESTS);
            error = SoulResultWrap.error((int)SoulResultEnum.SENTINEL_BLOCK_ERROR.getCode(), (String)SoulResultEnum.SENTINEL_BLOCK_ERROR.getMsg(), null);
        } else {
            return Mono.error((Throwable)throwable);
        }
        return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
    }
}

