/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.plugin.sentinel.handler;

import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRule;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRuleManager;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRuleManager;
import java.util.List;
import java.util.stream.Collectors;
import org.dromara.soul.common.dto.RuleData;
import org.dromara.soul.common.dto.convert.SentinelHandle;
import org.dromara.soul.common.enums.PluginEnum;
import org.dromara.soul.common.utils.GsonUtils;
import org.dromara.soul.plugin.base.handler.PluginDataHandler;

public class SentinelRuleHandle
implements PluginDataHandler {
    public void handlerRule(RuleData ruleData) {
        SentinelHandle sentinelHandle = (SentinelHandle)GsonUtils.getInstance().fromJson(ruleData.getHandle(), SentinelHandle.class);
        sentinelHandle.checkData(sentinelHandle);
        List flowRules = FlowRuleManager.getRules().stream().filter(r -> !r.getResource().equals(SentinelRuleHandle.getResourceName(ruleData))).collect(Collectors.toList());
        if (sentinelHandle.getFlowRuleEnable() == 1) {
            FlowRule rule = new FlowRule(SentinelRuleHandle.getResourceName(ruleData));
            rule.setCount((double)sentinelHandle.getFlowRuleCount().intValue());
            rule.setGrade(sentinelHandle.getFlowRuleGrade().intValue());
            rule.setControlBehavior(sentinelHandle.getFlowRuleControlBehavior().intValue());
            flowRules.add(rule);
        }
        FlowRuleManager.loadRules(flowRules);
        List degradeRules = DegradeRuleManager.getRules().stream().filter(r -> !r.getResource().equals(SentinelRuleHandle.getResourceName(ruleData))).collect(Collectors.toList());
        if (sentinelHandle.getDegradeRuleEnable() == 1) {
            DegradeRule rule = new DegradeRule(SentinelRuleHandle.getResourceName(ruleData));
            rule.setCount((double)sentinelHandle.getDegradeRuleCount().intValue());
            rule.setGrade(sentinelHandle.getDegradeRuleGrade().intValue());
            rule.setTimeWindow(sentinelHandle.getDegradeRuleTimeWindow().intValue());
            degradeRules.add(rule);
        }
        DegradeRuleManager.loadRules(degradeRules);
    }

    public void removeRule(RuleData ruleData) {
        FlowRuleManager.loadRules(FlowRuleManager.getRules().stream().filter(r -> !r.getResource().equals(SentinelRuleHandle.getResourceName(ruleData))).collect(Collectors.toList()));
        DegradeRuleManager.loadRules(DegradeRuleManager.getRules().stream().filter(r -> !r.getResource().equals(SentinelRuleHandle.getResourceName(ruleData))).collect(Collectors.toList()));
    }

    public String pluginNamed() {
        return PluginEnum.SENTINEL.getName();
    }

    public static String getResourceName(RuleData ruleData) {
        return ruleData.getSelectorId() + "_" + ruleData.getName();
    }
}

