/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.plugin.springcloud;

import java.net.URI;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.dromara.soul.common.dto.RuleData;
import org.dromara.soul.common.dto.SelectorData;
import org.dromara.soul.common.dto.convert.rule.SpringCloudRuleHandle;
import org.dromara.soul.common.enums.PluginEnum;
import org.dromara.soul.common.enums.RpcTypeEnum;
import org.dromara.soul.common.utils.GsonUtils;
import org.dromara.soul.plugin.api.SoulPluginChain;
import org.dromara.soul.plugin.api.context.SoulContext;
import org.dromara.soul.plugin.api.result.SoulResultEnum;
import org.dromara.soul.plugin.base.AbstractSoulPlugin;
import org.dromara.soul.plugin.base.utils.SoulResultWarp;
import org.dromara.soul.plugin.base.utils.WebFluxResultUtils;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.http.HttpMethod;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class SpringCloudPlugin
extends AbstractSoulPlugin {
    private final LoadBalancerClient loadBalancer;

    public SpringCloudPlugin(LoadBalancerClient loadBalancer) {
        this.loadBalancer = loadBalancer;
    }

    protected Mono<Void> doExecute(ServerWebExchange exchange, SoulPluginChain chain, SelectorData selector, RuleData rule) {
        if (Objects.isNull(rule)) {
            return Mono.empty();
        }
        SoulContext soulContext = (SoulContext)exchange.getAttribute("context");
        assert (soulContext != null);
        SpringCloudRuleHandle ruleHandle = (SpringCloudRuleHandle)GsonUtils.getInstance().fromJson(rule.getHandle(), SpringCloudRuleHandle.class);
        String serviceId = selector.getHandle();
        if (StringUtils.isBlank((CharSequence)serviceId) || StringUtils.isBlank((CharSequence)ruleHandle.getPath())) {
            Object error = SoulResultWarp.error((int)SoulResultEnum.CANNOT_CONFIG_SPRINGCLOUD_SERVICEID.getCode(), (String)SoulResultEnum.CANNOT_CONFIG_SPRINGCLOUD_SERVICEID.getMsg(), null);
            return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
        }
        ServiceInstance serviceInstance = this.loadBalancer.choose(serviceId);
        if (Objects.isNull(serviceInstance)) {
            Object error = SoulResultWarp.error((int)SoulResultEnum.SPRINGCLOUD_SERVICEID_IS_ERROR.getCode(), (String)SoulResultEnum.SPRINGCLOUD_SERVICEID_IS_ERROR.getMsg(), null);
            return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
        }
        URI uri = this.loadBalancer.reconstructURI(serviceInstance, URI.create(soulContext.getRealUrl()));
        String realURL = this.buildRealURL(uri.toASCIIString(), soulContext.getHttpMethod(), exchange.getRequest().getURI().getQuery());
        exchange.getAttributes().put("httpUrl", realURL);
        exchange.getAttributes().put("httpTimeOut", ruleHandle.getTimeout());
        return chain.execute(exchange);
    }

    public int getOrder() {
        return PluginEnum.SPRING_CLOUD.getCode();
    }

    public String named() {
        return PluginEnum.SPRING_CLOUD.getName();
    }

    public Boolean skip(ServerWebExchange exchange) {
        SoulContext body = (SoulContext)exchange.getAttribute("context");
        return !Objects.equals(Objects.requireNonNull(body).getRpcType(), RpcTypeEnum.SPRING_CLOUD.getName());
    }

    private String buildRealURL(String url, String httpMethod, String query) {
        if (httpMethod.equals(HttpMethod.GET.name()) && StringUtils.isNotBlank((CharSequence)query)) {
            return url + "?" + query;
        }
        return url;
    }
}

