/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.plugin.waf;

import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.dromara.soul.common.dto.RuleData;
import org.dromara.soul.common.dto.SelectorData;
import org.dromara.soul.common.dto.convert.WafHandle;
import org.dromara.soul.common.enums.PluginEnum;
import org.dromara.soul.common.enums.WafEnum;
import org.dromara.soul.common.enums.WafModelEnum;
import org.dromara.soul.common.utils.GsonUtils;
import org.dromara.soul.plugin.api.SoulPluginChain;
import org.dromara.soul.plugin.api.result.SoulResultWrap;
import org.dromara.soul.plugin.api.utils.WebFluxResultUtils;
import org.dromara.soul.plugin.base.AbstractSoulPlugin;
import org.dromara.soul.plugin.base.utils.Singleton;
import org.dromara.soul.plugin.waf.config.WafConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class WafPlugin
extends AbstractSoulPlugin {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WafPlugin.class);

    protected Mono<Void> doExecute(ServerWebExchange exchange, SoulPluginChain chain, SelectorData selector, RuleData rule) {
        WafConfig wafConfig = (WafConfig)Singleton.INST.get(WafConfig.class);
        if (Objects.isNull(selector) && Objects.isNull(rule)) {
            if (WafModelEnum.BLACK.getName().equals(wafConfig.getModel())) {
                return chain.execute(exchange);
            }
            exchange.getResponse().setStatusCode(HttpStatus.FORBIDDEN);
            Object error = SoulResultWrap.error((int)HttpStatus.FORBIDDEN.value(), (String)" You are forbidden to visit", null);
            return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
        }
        String handle = rule.getHandle();
        WafHandle wafHandle = (WafHandle)GsonUtils.getInstance().fromJson(handle, WafHandle.class);
        if (Objects.isNull(wafHandle) || StringUtils.isBlank((CharSequence)wafHandle.getPermission())) {
            log.error("waf handler can not configuration\uff1a{}", (Object)handle);
            return chain.execute(exchange);
        }
        if (WafEnum.REJECT.getName().equals(wafHandle.getPermission())) {
            exchange.getResponse().setStatusCode(HttpStatus.FORBIDDEN);
            Object error = SoulResultWrap.error((int)Integer.parseInt(wafHandle.getStatusCode()), (String)" You are forbidden to visit", null);
            return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
        }
        return chain.execute(exchange);
    }

    protected Mono<Void> handleSelectorIsNull(String pluginName, ServerWebExchange exchange, SoulPluginChain chain) {
        return this.doExecute(exchange, chain, null, null);
    }

    protected Mono<Void> handleRuleIsNull(String pluginName, ServerWebExchange exchange, SoulPluginChain chain) {
        return this.doExecute(exchange, chain, null, null);
    }

    public String named() {
        return PluginEnum.WAF.getName();
    }

    public int getOrder() {
        return PluginEnum.WAF.getCode();
    }
}

