/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.sync.data.nacos.handler;

import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.Listener;
import com.google.common.collect.Maps;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import org.dromara.soul.common.dto.AppAuthData;
import org.dromara.soul.common.dto.MetaData;
import org.dromara.soul.common.dto.PluginData;
import org.dromara.soul.common.dto.RuleData;
import org.dromara.soul.common.dto.SelectorData;
import org.dromara.soul.common.utils.GsonUtils;
import org.dromara.soul.sync.data.api.AuthDataSubscriber;
import org.dromara.soul.sync.data.api.MetaDataSubscriber;
import org.dromara.soul.sync.data.api.PluginDataSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosCacheHandler {
    private static final Logger log = LoggerFactory.getLogger(NacosCacheHandler.class);
    protected static final String GROUP = "DEFAULT_GROUP";
    protected static final String PLUGIN_DATA_ID = "soul.plugin.json";
    protected static final String SELECTOR_DATA_ID = "soul.selector.json";
    protected static final String RULE_DATA_ID = "soul.rule.json";
    protected static final String AUTH_DATA_ID = "soul.auth.json";
    protected static final String META_DATA_ID = "soul.meta.json";
    protected static final Map<String, List<Listener>> LISTENERS = Maps.newConcurrentMap();
    private final ConfigService configService;
    private final PluginDataSubscriber pluginDataSubscriber;
    private final List<MetaDataSubscriber> metaDataSubscribers;
    private final List<AuthDataSubscriber> authDataSubscribers;

    public NacosCacheHandler(ConfigService configService, PluginDataSubscriber pluginDataSubscriber, List<MetaDataSubscriber> metaDataSubscribers, List<AuthDataSubscriber> authDataSubscribers) {
        this.configService = configService;
        this.pluginDataSubscriber = pluginDataSubscriber;
        this.metaDataSubscribers = metaDataSubscribers;
        this.authDataSubscribers = authDataSubscribers;
    }

    protected void updatePluginMap(String configInfo) {
        try {
            List pluginDataList = GsonUtils.getInstance().fromList(configInfo, PluginData.class);
            pluginDataList.forEach(pluginData -> Optional.ofNullable(this.pluginDataSubscriber).ifPresent(e -> e.unSubscribe(pluginData)));
            pluginDataList.forEach(pluginData -> Optional.ofNullable(this.pluginDataSubscriber).ifPresent(e -> e.onSubscribe(pluginData)));
        }
        catch (JsonParseException e) {
            log.error("sync plugin data have error:", (Throwable)e);
        }
    }

    protected void updateSelectorMap(String configInfo) {
        try {
            List selectorDataList = GsonUtils.getInstance().fromList(configInfo, SelectorData.class);
            selectorDataList.forEach(selectorData -> Optional.ofNullable(this.pluginDataSubscriber).ifPresent(e -> e.unSelectorSubscribe(selectorData)));
            selectorDataList.forEach(selectorData -> Optional.ofNullable(this.pluginDataSubscriber).ifPresent(e -> e.onSelectorSubscribe(selectorData)));
        }
        catch (JsonParseException e) {
            log.error("sync selector data have error:", (Throwable)e);
        }
    }

    protected void updateRuleMap(String configInfo) {
        try {
            List ruleDataList = GsonUtils.getInstance().fromList(configInfo, RuleData.class);
            ruleDataList.forEach(ruleData -> Optional.ofNullable(this.pluginDataSubscriber).ifPresent(e -> e.unRuleSubscribe(ruleData)));
            ruleDataList.forEach(ruleData -> Optional.ofNullable(this.pluginDataSubscriber).ifPresent(e -> e.onRuleSubscribe(ruleData)));
        }
        catch (JsonParseException e) {
            log.error("sync rule data have error:", (Throwable)e);
        }
    }

    protected void updateMetaDataMap(String configInfo) {
        try {
            List metaDataList = GsonUtils.getInstance().fromList(configInfo, MetaData.class);
            metaDataList.forEach(metaData -> this.metaDataSubscribers.forEach(subscriber -> subscriber.unSubscribe(metaData)));
            metaDataList.forEach(metaData -> this.metaDataSubscribers.forEach(subscriber -> subscriber.onSubscribe(metaData)));
        }
        catch (JsonParseException e) {
            log.error("sync meta data have error:", (Throwable)e);
        }
    }

    protected void updateAuthMap(String configInfo) {
        try {
            List appAuthDataList = GsonUtils.getInstance().fromList(configInfo, AppAuthData.class);
            appAuthDataList.forEach(authData -> this.authDataSubscribers.forEach(subscriber -> subscriber.unSubscribe(authData)));
            appAuthDataList.forEach(authData -> this.authDataSubscribers.forEach(subscriber -> subscriber.onSubscribe(authData)));
        }
        catch (JsonParseException e) {
            log.error("sync auth data have error:", (Throwable)e);
        }
    }

    private String getConfigAndSignListener(String dataId, Listener listener) {
        return this.configService.getConfigAndSignListener(dataId, GROUP, 6000L, listener);
    }

    protected void watcherData(String dataId, final OnChange oc) {
        Listener listener = new Listener(){

            public void receiveConfigInfo(String configInfo) {
                oc.change(configInfo);
            }

            public Executor getExecutor() {
                return null;
            }
        };
        oc.change(this.getConfigAndSignListener(dataId, listener));
        ((List)LISTENERS.getOrDefault(dataId, new ArrayList())).add(listener);
    }

    public ConfigService getConfigService() {
        return this.configService;
    }

    protected static interface OnChange {
        public void change(String var1);
    }
}

