/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.sync.data.zookeeper;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.I0Itec.zkclient.IZkDataListener;
import org.I0Itec.zkclient.ZkClient;
import org.apache.commons.collections4.CollectionUtils;
import org.dromara.soul.common.constant.ZkPathConstants;
import org.dromara.soul.common.dto.AppAuthData;
import org.dromara.soul.common.dto.MetaData;
import org.dromara.soul.common.dto.PluginData;
import org.dromara.soul.common.dto.RuleData;
import org.dromara.soul.common.dto.SelectorData;
import org.dromara.soul.sync.data.api.AuthDataSubscriber;
import org.dromara.soul.sync.data.api.MetaDataSubscriber;
import org.dromara.soul.sync.data.api.PluginDataSubscriber;
import org.dromara.soul.sync.data.api.SyncDataService;

public class ZookeeperSyncDataService
implements SyncDataService,
AutoCloseable {
    private final ZkClient zkClient;
    private final PluginDataSubscriber pluginDataSubscriber;
    private final List<MetaDataSubscriber> metaDataSubscribers;
    private final List<AuthDataSubscriber> authDataSubscribers;

    public ZookeeperSyncDataService(ZkClient zkClient, PluginDataSubscriber pluginDataSubscriber, List<MetaDataSubscriber> metaDataSubscribers, List<AuthDataSubscriber> authDataSubscribers) {
        this.zkClient = zkClient;
        this.pluginDataSubscriber = pluginDataSubscriber;
        this.metaDataSubscribers = metaDataSubscribers;
        this.authDataSubscribers = authDataSubscribers;
        this.watcherData();
        this.watchAppAuth();
        this.watchMetaData();
    }

    private void watcherData() {
        String pluginParent = "/soul/plugin";
        if (!this.zkClient.exists("/soul/plugin")) {
            this.zkClient.createPersistent("/soul/plugin", true);
        }
        List pluginZKs = this.zkClient.getChildren(ZkPathConstants.buildPluginParentPath());
        for (String pluginName : pluginZKs) {
            this.watcherAll(pluginName);
        }
        this.zkClient.subscribeChildChanges("/soul/plugin", (parentPath, currentChildren) -> {
            if (CollectionUtils.isNotEmpty((Collection)currentChildren)) {
                for (String pluginName : currentChildren) {
                    this.watcherAll(pluginName);
                }
            }
        });
    }

    private void watcherAll(String pluginName) {
        this.watcherPlugin(pluginName);
        this.watcherSelector(pluginName);
        this.watcherRule(pluginName);
    }

    private void watcherPlugin(final String pluginName) {
        String pluginPath = ZkPathConstants.buildPluginPath((String)pluginName);
        if (!this.zkClient.exists(pluginPath)) {
            this.zkClient.createPersistent(pluginPath, true);
        }
        PluginData pluginData = (PluginData)this.zkClient.readData(pluginPath);
        Optional.ofNullable(pluginData).flatMap(data -> Optional.ofNullable(this.pluginDataSubscriber)).ifPresent(e -> e.onSubscribe(pluginData));
        this.zkClient.subscribeDataChanges(pluginPath, new IZkDataListener(){

            public void handleDataChange(String dataPath, Object data) {
                Optional.ofNullable(data).ifPresent(d -> Optional.ofNullable(ZookeeperSyncDataService.this.pluginDataSubscriber).ifPresent(e -> e.onSubscribe((PluginData)d)));
            }

            public void handleDataDeleted(String dataPath) {
                PluginData data = new PluginData();
                data.setName(pluginName);
                Optional.ofNullable(ZookeeperSyncDataService.this.pluginDataSubscriber).ifPresent(e -> e.unSubscribe(data));
            }
        });
    }

    private void watcherSelector(String pluginName) {
        List childrenList;
        String selectorParentPath = ZkPathConstants.buildSelectorParentPath((String)pluginName);
        if (!this.zkClient.exists(selectorParentPath)) {
            this.zkClient.createPersistent(selectorParentPath, true);
        }
        if (CollectionUtils.isNotEmpty((Collection)(childrenList = this.zkClient.getChildren(selectorParentPath)))) {
            childrenList.forEach(children -> {
                String realPath = this.buildRealPath(selectorParentPath, (String)children);
                this.cacheSelectorData((SelectorData)this.zkClient.readData(realPath));
                this.subscribeSelectorDataChanges(realPath);
            });
        }
        this.zkClient.subscribeChildChanges(selectorParentPath, (parentPath, currentChildren) -> {
            if (CollectionUtils.isNotEmpty((Collection)currentChildren)) {
                List<String> addSubscribePath = this.addSubscribePath(childrenList, currentChildren);
                addSubscribePath.stream().map(addPath -> {
                    String realPath = this.buildRealPath(parentPath, (String)addPath);
                    this.cacheSelectorData((SelectorData)this.zkClient.readData(realPath));
                    return realPath;
                }).forEach(this::subscribeSelectorDataChanges);
            }
        });
    }

    private void watcherRule(String pluginName) {
        List childrenList;
        String ruleParent = ZkPathConstants.buildRuleParentPath((String)pluginName);
        if (!this.zkClient.exists(ruleParent)) {
            this.zkClient.createPersistent(ruleParent, true);
        }
        if (CollectionUtils.isNotEmpty((Collection)(childrenList = this.zkClient.getChildren(ruleParent)))) {
            childrenList.forEach(children -> {
                String realPath = this.buildRealPath(ruleParent, (String)children);
                this.cacheRuleData((RuleData)this.zkClient.readData(realPath));
                this.subscribeRuleDataChanges(realPath);
            });
        }
        this.zkClient.subscribeChildChanges(ruleParent, (parentPath, currentChildren) -> {
            if (CollectionUtils.isNotEmpty((Collection)currentChildren)) {
                List<String> addSubscribePath = this.addSubscribePath(childrenList, currentChildren);
                addSubscribePath.stream().map(addPath -> {
                    String realPath = this.buildRealPath(parentPath, (String)addPath);
                    this.cacheRuleData((RuleData)this.zkClient.readData(realPath));
                    return realPath;
                }).forEach(this::subscribeRuleDataChanges);
            }
        });
    }

    private void watchAppAuth() {
        List childrenList;
        String appAuthParent = "/soul/auth";
        if (!this.zkClient.exists("/soul/auth")) {
            this.zkClient.createPersistent("/soul/auth", true);
        }
        if (CollectionUtils.isNotEmpty((Collection)(childrenList = this.zkClient.getChildren("/soul/auth")))) {
            childrenList.forEach(children -> {
                String realPath = this.buildRealPath("/soul/auth", (String)children);
                this.cacheAuthData((AppAuthData)this.zkClient.readData(realPath));
                this.subscribeAppAuthDataChanges(realPath);
            });
        }
        this.zkClient.subscribeChildChanges("/soul/auth", (parentPath, currentChildren) -> {
            if (CollectionUtils.isNotEmpty((Collection)currentChildren)) {
                List<String> addSubscribePath = this.addSubscribePath(childrenList, currentChildren);
                addSubscribePath.stream().map(children -> {
                    String realPath = this.buildRealPath(parentPath, (String)children);
                    this.cacheAuthData((AppAuthData)this.zkClient.readData(realPath));
                    return realPath;
                }).forEach(this::subscribeAppAuthDataChanges);
            }
        });
    }

    private void watchMetaData() {
        List childrenList;
        String metaDataPath = "/soul/metaData";
        if (!this.zkClient.exists("/soul/metaData")) {
            this.zkClient.createPersistent("/soul/metaData", true);
        }
        if (CollectionUtils.isNotEmpty((Collection)(childrenList = this.zkClient.getChildren("/soul/metaData")))) {
            childrenList.forEach(children -> {
                String realPath = this.buildRealPath("/soul/metaData", (String)children);
                this.cacheMetaData((MetaData)this.zkClient.readData(realPath));
                this.subscribeMetaDataChanges(realPath);
            });
        }
        this.zkClient.subscribeChildChanges("/soul/metaData", (parentPath, currentChildren) -> {
            if (CollectionUtils.isNotEmpty((Collection)currentChildren)) {
                List<String> addSubscribePath = this.addSubscribePath(childrenList, currentChildren);
                addSubscribePath.stream().map(children -> {
                    String realPath = this.buildRealPath(parentPath, (String)children);
                    this.cacheMetaData((MetaData)this.zkClient.readData(realPath));
                    return realPath;
                }).forEach(this::subscribeMetaDataChanges);
            }
        });
    }

    private void subscribeSelectorDataChanges(String path) {
        this.zkClient.subscribeDataChanges(path, new IZkDataListener(){

            public void handleDataChange(String dataPath, Object data) {
                ZookeeperSyncDataService.this.cacheSelectorData((SelectorData)data);
            }

            public void handleDataDeleted(String dataPath) {
                ZookeeperSyncDataService.this.unCacheSelectorData(dataPath);
            }
        });
    }

    private void subscribeRuleDataChanges(String path) {
        this.zkClient.subscribeDataChanges(path, new IZkDataListener(){

            public void handleDataChange(String dataPath, Object data) {
                ZookeeperSyncDataService.this.cacheRuleData((RuleData)data);
            }

            public void handleDataDeleted(String dataPath) {
                ZookeeperSyncDataService.this.unCacheRuleData(dataPath);
            }
        });
    }

    private void subscribeAppAuthDataChanges(String realPath) {
        this.zkClient.subscribeDataChanges(realPath, new IZkDataListener(){

            public void handleDataChange(String dataPath, Object data) {
                ZookeeperSyncDataService.this.cacheAuthData((AppAuthData)data);
            }

            public void handleDataDeleted(String dataPath) {
                ZookeeperSyncDataService.this.unCacheAuthData(dataPath);
            }
        });
    }

    private void subscribeMetaDataChanges(String realPath) {
        this.zkClient.subscribeDataChanges(realPath, new IZkDataListener(){

            public void handleDataChange(String dataPath, Object data) {
                ZookeeperSyncDataService.this.cacheMetaData((MetaData)data);
            }

            public void handleDataDeleted(String dataPath) {
                String realPath = dataPath.substring("/soul/metaData".length() + 1);
                MetaData metaData = new MetaData();
                metaData.setPath(URLDecoder.decode(realPath, "UTF-8"));
                ZookeeperSyncDataService.this.unCacheMetaData(metaData);
            }
        });
    }

    private void cacheSelectorData(SelectorData selectorData) {
        Optional.ofNullable(selectorData).ifPresent(data -> Optional.ofNullable(this.pluginDataSubscriber).ifPresent(e -> e.onSelectorSubscribe(data)));
    }

    private void unCacheSelectorData(String dataPath) {
        SelectorData selectorData = new SelectorData();
        String selectorId = dataPath.substring(dataPath.lastIndexOf("/") + 1);
        String str = dataPath.substring("/soul/selector".length());
        String pluginName = str.substring(1, str.length() - selectorId.length() - 1);
        selectorData.setPluginName(pluginName);
        selectorData.setId(selectorId);
        Optional.ofNullable(this.pluginDataSubscriber).ifPresent(e -> e.unSelectorSubscribe(selectorData));
    }

    private void cacheRuleData(RuleData ruleData) {
        Optional.ofNullable(ruleData).ifPresent(data -> Optional.ofNullable(this.pluginDataSubscriber).ifPresent(e -> e.onRuleSubscribe(data)));
    }

    private void unCacheRuleData(String dataPath) {
        String substring = dataPath.substring(dataPath.lastIndexOf("/") + 1);
        String str = dataPath.substring("/soul/rule".length());
        String pluginName = str.substring(1, str.length() - substring.length() - 1);
        ArrayList list = Lists.newArrayList((Iterable)Splitter.on((String)"-").split((CharSequence)substring));
        RuleData ruleData = new RuleData();
        ruleData.setPluginName(pluginName);
        ruleData.setSelectorId((String)list.get(0));
        ruleData.setId((String)list.get(1));
        Optional.ofNullable(this.pluginDataSubscriber).ifPresent(e -> e.unRuleSubscribe(ruleData));
    }

    private void cacheAuthData(AppAuthData appAuthData) {
        Optional.ofNullable(appAuthData).ifPresent(data -> this.authDataSubscribers.forEach(e -> e.onSubscribe(data)));
    }

    private void unCacheAuthData(String dataPath) {
        String key = dataPath.substring("/soul/auth".length() + 1);
        AppAuthData appAuthData = new AppAuthData();
        appAuthData.setAppKey(key);
        this.authDataSubscribers.forEach(e -> e.unSubscribe(appAuthData));
    }

    private void cacheMetaData(MetaData metaData) {
        Optional.ofNullable(metaData).ifPresent(data -> this.metaDataSubscribers.forEach(e -> e.onSubscribe(metaData)));
    }

    private void unCacheMetaData(MetaData metaData) {
        Optional.ofNullable(metaData).ifPresent(data -> this.metaDataSubscribers.forEach(e -> e.unSubscribe(metaData)));
    }

    private List<String> addSubscribePath(List<String> alreadyChildren, List<String> currentChildren) {
        if (CollectionUtils.isEmpty(alreadyChildren)) {
            return currentChildren;
        }
        return currentChildren.stream().filter(current -> alreadyChildren.stream().noneMatch(current::equals)).collect(Collectors.toList());
    }

    private String buildRealPath(String parent, String children) {
        return parent + "/" + children;
    }

    @Override
    public void close() {
        if (null != this.zkClient) {
            this.zkClient.close();
        }
    }
}

