/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.balance.spi;

import com.alibaba.dubbo.common.utils.AtomicPositiveInteger;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.dromara.soul.common.dto.convert.DivideUpstream;
import org.dromara.soul.common.enums.LoadBalanceEnum;
import org.dromara.soul.web.balance.LoadBalance;

public class RoundRobinLoadBalance
implements LoadBalance {
    private final ConcurrentMap<String, AtomicPositiveInteger> sequences = new ConcurrentHashMap<String, AtomicPositiveInteger>();
    private final ConcurrentMap<String, AtomicPositiveInteger> weightSequences = new ConcurrentHashMap<String, AtomicPositiveInteger>();

    @Override
    public DivideUpstream select(List<DivideUpstream> upstreamList, String ip) {
        AtomicPositiveInteger sequence;
        List<Object> resultUpstreamList = upstreamList;
        String key = resultUpstreamList.get(0).getUpstreamUrl();
        int length = resultUpstreamList.size();
        int maxWeight = 0;
        int minWeight = Integer.MAX_VALUE;
        for (int i = 0; i < length; ++i) {
            int weight = resultUpstreamList.get(i).getWeight();
            maxWeight = Math.max(maxWeight, weight);
            minWeight = Math.min(minWeight, weight);
        }
        if (maxWeight > 0 && minWeight < maxWeight) {
            AtomicPositiveInteger weightSequence = (AtomicPositiveInteger)this.weightSequences.get(key);
            if (weightSequence == null) {
                this.weightSequences.putIfAbsent(key, new AtomicPositiveInteger());
                weightSequence = (AtomicPositiveInteger)this.weightSequences.get(key);
            }
            int currentWeight = weightSequence.getAndIncrement() % maxWeight;
            List weightInvokers = resultUpstreamList.stream().filter(divideHandle -> divideHandle.getWeight() > currentWeight).collect(Collectors.toList());
            int weightLength = weightInvokers.size();
            if (weightLength == 1) {
                return (DivideUpstream)weightInvokers.get(0);
            }
            if (weightLength > 1) {
                resultUpstreamList = weightInvokers;
                length = resultUpstreamList.size();
            }
        }
        if ((sequence = (AtomicPositiveInteger)this.sequences.get(key)) == null) {
            this.sequences.putIfAbsent(key, new AtomicPositiveInteger());
            sequence = (AtomicPositiveInteger)this.sequences.get(key);
        }
        return resultUpstreamList.get(sequence.getAndIncrement() % length);
    }

    @Override
    public String algorithm() {
        return LoadBalanceEnum.ROUND_ROBIN.getName();
    }
}

