/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.cache;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.I0Itec.zkclient.IZkDataListener;
import org.I0Itec.zkclient.ZkClient;
import org.apache.commons.collections4.CollectionUtils;
import org.dromara.soul.common.constant.ZkPathConstants;
import org.dromara.soul.common.dto.zk.AppAuthZkDTO;
import org.dromara.soul.common.dto.zk.PluginZkDTO;
import org.dromara.soul.common.dto.zk.RuleZkDTO;
import org.dromara.soul.common.dto.zk.SelectorZkDTO;
import org.dromara.soul.common.enums.PluginEnum;
import org.dromara.soul.web.cache.UpstreamCacheManager;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

@Component
public class ZookeeperCacheManager
implements CommandLineRunner,
DisposableBean {
    private static final Map<String, PluginZkDTO> PLUGIN_MAP = Maps.newConcurrentMap();
    private static final Map<String, List<SelectorZkDTO>> SELECTOR_MAP = Maps.newConcurrentMap();
    private static final Map<String, List<RuleZkDTO>> RULE_MAP = Maps.newConcurrentMap();
    private static final Map<String, AppAuthZkDTO> AUTH_MAP = Maps.newConcurrentMap();
    private final ZkClient zkClient;
    @Value(value="${soul.upstream.time:30}")
    private int upstreamTime;

    @Autowired(required=false)
    public ZookeeperCacheManager(ZkClient zkClient) {
        this.zkClient = zkClient;
    }

    public AppAuthZkDTO findAuthDTOByAppKey(String appKey) {
        return AUTH_MAP.get(appKey);
    }

    public PluginZkDTO findPluginByName(String pluginName) {
        return PLUGIN_MAP.get(pluginName);
    }

    public List<SelectorZkDTO> findSelectorByPluginName(String pluginName) {
        return SELECTOR_MAP.get(pluginName);
    }

    public List<RuleZkDTO> findRuleBySelectorId(String selectorId) {
        return RULE_MAP.get(selectorId);
    }

    public void run(String ... args) {
        this.watcherData();
        this.watchAppAuth();
    }

    private void watcherData() {
        String pluginParent = "/soul/plugin";
        if (!this.zkClient.exists("/soul/plugin")) {
            this.zkClient.createPersistent("/soul/plugin", true);
        }
        List pluginZKs = this.zkClient.getChildren(ZkPathConstants.buildPluginParentPath());
        for (String pluginName : pluginZKs) {
            this.loadPlugin(pluginName);
        }
        this.zkClient.subscribeChildChanges("/soul/plugin", (parentPath, currentChildren) -> {
            if (CollectionUtils.isNotEmpty((Collection)currentChildren)) {
                for (String pluginName : currentChildren) {
                    this.loadPlugin(pluginName);
                }
            }
        });
    }

    private void loadPlugin(String pluginName) {
        this.watcherPlugin(pluginName);
        this.watcherSelector(pluginName);
        this.watcherRule(pluginName);
    }

    private void watcherPlugin(final String pluginName) {
        String pluginPath = ZkPathConstants.buildPluginPath((String)pluginName);
        if (!this.zkClient.exists(pluginPath)) {
            this.zkClient.createPersistent(pluginPath, true);
        }
        PluginZkDTO data = (PluginZkDTO)this.zkClient.readData(pluginPath);
        Optional.ofNullable(data).ifPresent(d -> PLUGIN_MAP.put(pluginName, data));
        this.zkClient.subscribeDataChanges(pluginPath, new IZkDataListener(){

            public void handleDataChange(String dataPath, Object data) {
                Optional.ofNullable(data).ifPresent(o -> {
                    PluginZkDTO dto = (PluginZkDTO)o;
                    PLUGIN_MAP.put(dto.getName(), dto);
                });
            }

            public void handleDataDeleted(String dataPath) {
                PLUGIN_MAP.remove(pluginName);
            }
        });
    }

    private void watcherSelector(String pluginName) {
        List childrenList;
        String selectorParentPath = ZkPathConstants.buildSelectorParentPath((String)pluginName);
        if (!this.zkClient.exists(selectorParentPath)) {
            this.zkClient.createPersistent(selectorParentPath, true);
        }
        if (CollectionUtils.isNotEmpty((Collection)(childrenList = this.zkClient.getChildren(selectorParentPath)))) {
            childrenList.forEach(children -> {
                String realPath = this.buildRealPath(selectorParentPath, (String)children);
                this.setSelectorData(realPath);
                this.subscribeSelectorDataChanges(realPath);
            });
        }
        this.zkClient.subscribeChildChanges(selectorParentPath, (parentPath, currentChildren) -> {
            if (CollectionUtils.isNotEmpty((Collection)currentChildren)) {
                List<String> addSubscribePath = this.addSubscribePath(childrenList, currentChildren);
                addSubscribePath.stream().map(addPath -> {
                    String realPath = this.buildRealPath(parentPath, (String)addPath);
                    this.setSelectorData(realPath);
                    return realPath;
                }).forEach(this::subscribeSelectorDataChanges);
            }
        });
    }

    private void watcherRule(String pluginName) {
        List childrenList;
        String ruleParent = ZkPathConstants.buildRuleParentPath((String)pluginName);
        if (!this.zkClient.exists(ruleParent)) {
            this.zkClient.createPersistent(ruleParent, true);
        }
        if (CollectionUtils.isNotEmpty((Collection)(childrenList = this.zkClient.getChildren(ruleParent)))) {
            childrenList.forEach(children -> {
                String realPath = this.buildRealPath(ruleParent, (String)children);
                this.setRuleData(realPath);
                this.subscribeRuleDataChanges(realPath);
            });
        }
        this.zkClient.subscribeChildChanges(ruleParent, (parentPath, currentChildren) -> {
            if (CollectionUtils.isNotEmpty((Collection)currentChildren)) {
                List<String> addSubscribePath = this.addSubscribePath(childrenList, currentChildren);
                addSubscribePath.stream().map(addPath -> {
                    String realPath = this.buildRealPath(parentPath, (String)addPath);
                    this.setRuleData(realPath);
                    return realPath;
                }).forEach(this::subscribeRuleDataChanges);
            }
        });
    }

    private void setSelectorMapByKey(String key, SelectorZkDTO selectorZkDTO) {
        Optional.ofNullable(key).ifPresent(k -> {
            if (selectorZkDTO.getPluginName().equals(PluginEnum.DIVIDE.getName())) {
                UpstreamCacheManager.submit(selectorZkDTO);
            }
            if (SELECTOR_MAP.containsKey(k)) {
                List<SelectorZkDTO> selectorZkDTOList = SELECTOR_MAP.get(key);
                List resultList = selectorZkDTOList.stream().filter(r -> !r.getId().equals(selectorZkDTO.getId())).collect(Collectors.toList());
                resultList.add(selectorZkDTO);
                List collect = resultList.stream().sorted(Comparator.comparing(SelectorZkDTO::getSort)).collect(Collectors.toList());
                SELECTOR_MAP.put(key, collect);
            } else {
                SELECTOR_MAP.put(key, Lists.newArrayList((Object[])new SelectorZkDTO[]{selectorZkDTO}));
            }
        });
    }

    private void subscribeSelectorDataChanges(String path) {
        this.zkClient.subscribeDataChanges(path, new IZkDataListener(){

            public void handleDataChange(String dataPath, Object data) {
                Optional.ofNullable(data).ifPresent(d -> ZookeeperCacheManager.this.selectorDataChange((SelectorZkDTO)d));
            }

            public void handleDataDeleted(String dataPath) {
                String id = dataPath.substring(dataPath.lastIndexOf("/") + 1);
                String str = dataPath.substring("/soul/selector".length());
                String key = str.substring(1, str.length() - id.length() - 1);
                Optional.of(key).ifPresent(k -> {
                    List selectorZkDTOList = (List)SELECTOR_MAP.get(k);
                    selectorZkDTOList.removeIf(e -> e.getId().equals(id));
                });
            }
        });
    }

    private void setSelectorData(String realPath) {
        SelectorZkDTO selectorZkDTO = (SelectorZkDTO)this.zkClient.readData(realPath);
        Optional.ofNullable(selectorZkDTO).ifPresent(dto -> {
            String key = dto.getPluginName();
            this.setSelectorMapByKey(key, (SelectorZkDTO)dto);
        });
    }

    private void setRuleData(String rulePath) {
        RuleZkDTO ruleZkDTO = (RuleZkDTO)this.zkClient.readData(rulePath);
        Optional.ofNullable(ruleZkDTO).ifPresent(dto -> {
            String key = dto.getSelectorId();
            this.setRuleMapByKey(key, ruleZkDTO);
        });
    }

    private void setRuleMapByKey(String key, RuleZkDTO ruleZkDTO) {
        Optional.ofNullable(key).ifPresent(k -> {
            if (RULE_MAP.containsKey(k)) {
                List<RuleZkDTO> ruleZkDTOList = RULE_MAP.get(key);
                List resultList = ruleZkDTOList.stream().filter(r -> !r.getId().equals(ruleZkDTO.getId())).collect(Collectors.toList());
                resultList.add(ruleZkDTO);
                List collect = resultList.stream().sorted(Comparator.comparing(RuleZkDTO::getSort)).collect(Collectors.toList());
                RULE_MAP.put(key, collect);
            } else {
                RULE_MAP.put(key, Lists.newArrayList((Object[])new RuleZkDTO[]{ruleZkDTO}));
            }
        });
    }

    private void subscribeRuleDataChanges(String path) {
        this.zkClient.subscribeDataChanges(path, new IZkDataListener(){

            public void handleDataChange(String dataPath, Object data) {
                Optional.ofNullable(data).ifPresent(d -> ZookeeperCacheManager.this.ruleDataChange((RuleZkDTO)d));
            }

            public void handleDataDeleted(String dataPath) {
                List list = Splitter.on((String)"-").splitToList((CharSequence)dataPath.substring(dataPath.lastIndexOf("/") + 1));
                String key = (String)list.get(0);
                String id = (String)list.get(1);
                UpstreamCacheManager.removeByKey(id);
                Optional.ofNullable(key).ifPresent(k -> {
                    List ruleZkDTOList = (List)RULE_MAP.get(k);
                    ruleZkDTOList.removeIf(e -> e.getId().equals(id));
                });
            }
        });
    }

    private void selectorDataChange(SelectorZkDTO dto) {
        String key;
        List<SelectorZkDTO> selectorZkDTOList;
        if (dto.getPluginName().equals(PluginEnum.DIVIDE.getName())) {
            UpstreamCacheManager.submit(dto);
        }
        if (CollectionUtils.isNotEmpty(selectorZkDTOList = SELECTOR_MAP.get(key = dto.getPluginName()))) {
            List resultList = selectorZkDTOList.stream().filter(r -> !r.getId().equals(dto.getId())).collect(Collectors.toList());
            resultList.add(dto);
            List collect = resultList.stream().sorted(Comparator.comparing(SelectorZkDTO::getSort)).collect(Collectors.toList());
            SELECTOR_MAP.put(key, collect);
        } else {
            SELECTOR_MAP.put(key, Lists.newArrayList((Object[])new SelectorZkDTO[]{dto}));
        }
    }

    private void ruleDataChange(RuleZkDTO dto) {
        String key = dto.getSelectorId();
        List<RuleZkDTO> ruleZkDTOList = RULE_MAP.get(key);
        if (CollectionUtils.isNotEmpty(ruleZkDTOList)) {
            List resultList = ruleZkDTOList.stream().filter(r -> !r.getId().equals(dto.getId())).collect(Collectors.toList());
            resultList.add(dto);
            List collect = resultList.stream().sorted(Comparator.comparing(RuleZkDTO::getSort)).collect(Collectors.toList());
            RULE_MAP.put(key, collect);
        } else {
            RULE_MAP.put(key, Lists.newArrayList((Object[])new RuleZkDTO[]{dto}));
        }
    }

    private void watchAppAuth() {
        List childrenList;
        String appAuthParent = "/soul/auth";
        if (!this.zkClient.exists("/soul/auth")) {
            this.zkClient.createPersistent("/soul/auth", true);
        }
        if (CollectionUtils.isNotEmpty((Collection)(childrenList = this.zkClient.getChildren("/soul/auth")))) {
            childrenList.forEach(children -> {
                String realPath = this.buildRealPath("/soul/auth", (String)children);
                this.setAuthData(realPath);
                this.subscribeAppAuthDataChanges(realPath);
            });
        }
        this.zkClient.subscribeChildChanges("/soul/auth", (parentPath, currentChildren) -> {
            if (CollectionUtils.isNotEmpty((Collection)currentChildren)) {
                List<String> addSubscribePath = this.addSubscribePath(childrenList, currentChildren);
                addSubscribePath.stream().map(children -> {
                    String realPath = this.buildRealPath(parentPath, (String)children);
                    this.setAuthData(realPath);
                    return realPath;
                }).forEach(this::subscribeAppAuthDataChanges);
            }
        });
    }

    private void setAuthData(String realPath) {
        AppAuthZkDTO appAuthZkDTO = (AppAuthZkDTO)this.zkClient.readData(realPath);
        Optional.ofNullable(appAuthZkDTO).ifPresent(dto -> AUTH_MAP.put(dto.getAppKey(), (AppAuthZkDTO)dto));
    }

    private void subscribeAppAuthDataChanges(String realPath) {
        this.zkClient.subscribeDataChanges(realPath, new IZkDataListener(){

            public void handleDataChange(String dataPath, Object data) {
                Optional.ofNullable(data).ifPresent(o -> AUTH_MAP.put(((AppAuthZkDTO)o).getAppKey(), (AppAuthZkDTO)o));
            }

            public void handleDataDeleted(String dataPath) {
                String key = dataPath.substring("/soul/auth".length() + 1);
                AUTH_MAP.remove(key);
            }
        });
    }

    private List<String> addSubscribePath(List<String> alreadyChildren, List<String> currentChildren) {
        if (CollectionUtils.isEmpty(alreadyChildren)) {
            return currentChildren;
        }
        return currentChildren.stream().filter(current -> alreadyChildren.stream().noneMatch(current::equals)).collect(Collectors.toList());
    }

    private String buildRealPath(String parent, String children) {
        return parent + "/" + children;
    }

    public void destroy() {
        this.zkClient.close();
    }
}

