/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.condition.judge;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.dromara.soul.common.dto.zk.ConditionZkDTO;
import org.dromara.soul.common.enums.OperatorEnum;
import org.dromara.soul.web.condition.judge.EqOperatorJudge;
import org.dromara.soul.web.condition.judge.LikeOperatorJudge;
import org.dromara.soul.web.condition.judge.MatchOperatorJudge;
import org.dromara.soul.web.condition.judge.OperatorJudge;
import org.dromara.soul.web.condition.judge.RegExOperatorJudge;

public class OperatorJudgeFactory {
    private static final Map<String, OperatorJudge> OPERATOR_JUDGE_MAP = Maps.newHashMapWithExpectedSize((int)4);

    public static Boolean judge(ConditionZkDTO conditionZkDTO, String realData) {
        if (Objects.isNull(conditionZkDTO) || StringUtils.isBlank((CharSequence)realData)) {
            return false;
        }
        return OPERATOR_JUDGE_MAP.get(conditionZkDTO.getOperator()).judge(conditionZkDTO, realData);
    }

    static {
        OPERATOR_JUDGE_MAP.put(OperatorEnum.EQ.getAlias(), new EqOperatorJudge());
        OPERATOR_JUDGE_MAP.put(OperatorEnum.MATCH.getAlias(), new MatchOperatorJudge());
        OPERATOR_JUDGE_MAP.put(OperatorEnum.LIKE.getAlias(), new LikeOperatorJudge());
        OPERATOR_JUDGE_MAP.put(OperatorEnum.REGEX.getAlias(), new RegExOperatorJudge());
    }
}

