/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.condition.strategy;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.dromara.soul.common.dto.zk.ConditionZkDTO;
import org.dromara.soul.common.enums.ParamTypeEnum;
import org.dromara.soul.common.utils.ReflectUtils;
import org.dromara.soul.web.request.RequestDTO;
import org.springframework.http.HttpHeaders;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;

abstract class AbstractMatchStrategy {
    AbstractMatchStrategy() {
    }

    String buildRealData(ConditionZkDTO condition, ServerWebExchange exchange) {
        String realData = "";
        if (condition.getParamType().equals(ParamTypeEnum.QUERY.getName())) {
            MultiValueMap queryParams = exchange.getRequest().getQueryParams();
            realData = (String)queryParams.getFirst((Object)condition.getParamName());
        } else if (Objects.equals(ParamTypeEnum.HOST.getName(), condition.getParamType())) {
            realData = Objects.requireNonNull(exchange.getRequest().getRemoteAddress()).getHostString();
        } else if (Objects.equals(ParamTypeEnum.IP.getName(), condition.getParamType())) {
            realData = Objects.requireNonNull(exchange.getRequest().getRemoteAddress()).getAddress().getHostAddress();
        } else if (Objects.equals(ParamTypeEnum.HEADER.getName(), condition.getParamType())) {
            HttpHeaders headers = exchange.getRequest().getHeaders();
            List list = headers.get((Object)condition.getParamName());
            if (CollectionUtils.isEmpty((Collection)list)) {
                return realData;
            }
            realData = Objects.requireNonNull(headers.get((Object)condition.getParamName())).stream().findFirst().orElse("");
        } else if (condition.getParamType().equals(ParamTypeEnum.POST.getName())) {
            RequestDTO requestDTO = (RequestDTO)exchange.getAttribute("requestDTO");
            realData = (String)ReflectUtils.getFieldValue((Object)requestDTO, (String)condition.getParamName());
        }
        return realData;
    }
}

