/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.config;

import org.influxdb.dto.Point;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.influxdb.DefaultInfluxDBTemplate;
import org.springframework.data.influxdb.InfluxDBConnectionFactory;
import org.springframework.data.influxdb.InfluxDBProperties;
import org.springframework.data.influxdb.InfluxDBTemplate;
import org.springframework.data.influxdb.converter.PointCollectionConverter;
import org.springframework.data.influxdb.converter.PointConverter;

@Configuration
@EnableConfigurationProperties(value={InfluxDBProperties.class})
@ConditionalOnProperty(prefix="spring.influxdb", name={"url"})
public class InfluxDbConfiguration {
    @Bean
    public InfluxDBConnectionFactory connectionFactory(InfluxDBProperties influxDBProperties) {
        return new InfluxDBConnectionFactory(influxDBProperties);
    }

    @Bean
    public InfluxDBTemplate<Point> influxDBTemplate(InfluxDBConnectionFactory connectionFactory) {
        return new InfluxDBTemplate(connectionFactory, (PointCollectionConverter)new PointConverter());
    }

    @Bean
    public DefaultInfluxDBTemplate defaultTemplate(InfluxDBConnectionFactory connectionFactory) {
        return new DefaultInfluxDBTemplate(connectionFactory);
    }
}

