/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.config;

import java.util.List;
import org.dromara.soul.web.config.SoulConfiguration;
import org.dromara.soul.web.plugin.ratelimter.RedisRateLimiter;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.data.redis.connection.ReactiveRedisConnectionFactory;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.scripting.ScriptSource;
import org.springframework.scripting.support.ResourceScriptSource;
import org.springframework.web.reactive.DispatcherHandler;

@Configuration
@AutoConfigureBefore(value={SoulConfiguration.class})
@ConditionalOnClass(value={RedisTemplate.class, DispatcherHandler.class})
public class RedisConfiguration {
    @Bean
    public RedisScript redisScript() {
        DefaultRedisScript redisScript = new DefaultRedisScript();
        redisScript.setScriptSource((ScriptSource)new ResourceScriptSource((Resource)new ClassPathResource("/META-INF/scripts/request_rate_limiter.lua")));
        redisScript.setResultType(List.class);
        return redisScript;
    }

    @Bean
    @Qualifier(value="reactiveRedisTemplate")
    public ReactiveRedisTemplate<String, String> stringReactiveRedisTemplate(ReactiveRedisConnectionFactory reactiveRedisConnectionFactory) {
        StringRedisSerializer serializer = new StringRedisSerializer();
        RedisSerializationContext serializationContext = RedisSerializationContext.newSerializationContext().key((RedisSerializer)serializer).value((RedisSerializer)serializer).hashKey((RedisSerializer)serializer).hashValue((RedisSerializer)serializer).build();
        return new ReactiveRedisTemplate(reactiveRedisConnectionFactory, serializationContext);
    }

    @Bean
    @ConditionalOnMissingBean
    public RedisRateLimiter redisRateLimiter(@Qualifier(value="reactiveRedisTemplate") ReactiveRedisTemplate<String, String> reactiveRedisTemplate) {
        return new RedisRateLimiter(reactiveRedisTemplate, (RedisScript<List<Long>>)this.redisScript());
    }
}

