/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.config;

import java.util.List;
import java.util.stream.Collectors;
import org.dromara.soul.web.cache.UpstreamCacheManager;
import org.dromara.soul.web.cache.ZookeeperCacheManager;
import org.dromara.soul.web.disruptor.publisher.SoulEventPublisher;
import org.dromara.soul.web.filter.BodyWebFilter;
import org.dromara.soul.web.filter.ParamWebFilter;
import org.dromara.soul.web.filter.TimeWebFilter;
import org.dromara.soul.web.filter.WebSocketWebFilter;
import org.dromara.soul.web.handler.SoulHandlerMapping;
import org.dromara.soul.web.handler.SoulWebHandler;
import org.dromara.soul.web.plugin.SoulPlugin;
import org.dromara.soul.web.plugin.after.MonitorPlugin;
import org.dromara.soul.web.plugin.after.ResponsePlugin;
import org.dromara.soul.web.plugin.before.GlobalPlugin;
import org.dromara.soul.web.plugin.before.SignPlugin;
import org.dromara.soul.web.plugin.before.WafPlugin;
import org.dromara.soul.web.plugin.dubbo.GenericParamService;
import org.dromara.soul.web.plugin.dubbo.GenericParamServiceImpl;
import org.dromara.soul.web.plugin.function.DividePlugin;
import org.dromara.soul.web.plugin.function.RateLimiterPlugin;
import org.dromara.soul.web.plugin.function.RewritePlugin;
import org.dromara.soul.web.plugin.function.WebSocketPlugin;
import org.dromara.soul.web.plugin.ratelimter.RedisRateLimiter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.web.reactive.socket.client.ReactorNettyWebSocketClient;
import org.springframework.web.reactive.socket.client.WebSocketClient;
import org.springframework.web.reactive.socket.server.WebSocketService;
import org.springframework.web.reactive.socket.server.support.HandshakeWebSocketService;
import org.springframework.web.server.WebFilter;

@Configuration
@ComponentScan(value={"org.dromara.soul"})
public class SoulConfiguration {
    private final ZookeeperCacheManager zookeeperCacheManager;
    private final SoulEventPublisher soulEventPublisher;
    private final RedisRateLimiter redisRateLimiter;
    private final UpstreamCacheManager upstreamCacheManager;

    @Autowired(required=false)
    public SoulConfiguration(ZookeeperCacheManager zookeeperCacheManager, SoulEventPublisher soulEventPublisher, RedisRateLimiter redisRateLimiter, UpstreamCacheManager upstreamCacheManager) {
        this.zookeeperCacheManager = zookeeperCacheManager;
        this.soulEventPublisher = soulEventPublisher;
        this.redisRateLimiter = redisRateLimiter;
        this.upstreamCacheManager = upstreamCacheManager;
    }

    @Bean
    public SoulPlugin globalPlugin() {
        return new GlobalPlugin();
    }

    @Bean
    public SoulPlugin signPlugin() {
        return new SignPlugin(this.zookeeperCacheManager);
    }

    @Bean
    public SoulPlugin wafPlugin() {
        return new WafPlugin(this.zookeeperCacheManager);
    }

    @Bean
    public SoulPlugin monitorPlugin() {
        return new MonitorPlugin(this.soulEventPublisher, this.zookeeperCacheManager);
    }

    @Bean
    public SoulPlugin rateLimiterPlugin() {
        return new RateLimiterPlugin(this.zookeeperCacheManager, this.redisRateLimiter);
    }

    @Bean
    public SoulPlugin rewritePlugin() {
        return new RewritePlugin(this.zookeeperCacheManager);
    }

    @Bean
    public SoulPlugin dividePlugin() {
        return new DividePlugin(this.zookeeperCacheManager, this.upstreamCacheManager);
    }

    @Bean
    public WebSocketPlugin webSocketPlugin(WebSocketClient webSocketClient, WebSocketService webSocketService) {
        return new WebSocketPlugin(this.zookeeperCacheManager, this.upstreamCacheManager, webSocketClient, webSocketService);
    }

    @Bean
    public SoulPlugin responsePlugin() {
        return new ResponsePlugin();
    }

    @Bean
    public SoulWebHandler soulWebHandler(List<SoulPlugin> plugins) {
        List<SoulPlugin> soulPlugins = plugins.stream().sorted((m, n) -> {
            if (m.pluginType().equals((Object)n.pluginType())) {
                return m.getOrder() - n.getOrder();
            }
            return m.pluginType().getName().compareTo(n.pluginType().getName());
        }).collect(Collectors.toList());
        return new SoulWebHandler(soulPlugins);
    }

    @Bean
    public SoulHandlerMapping soulHandlerMapping(SoulWebHandler soulWebHandler) {
        return new SoulHandlerMapping(soulWebHandler);
    }

    @Bean
    @Order(value=-1)
    public WebFilter bodyWebFilter() {
        return new BodyWebFilter();
    }

    @Bean
    @Order(value=1)
    public WebFilter paramWebFilter() {
        return new ParamWebFilter();
    }

    @Bean
    @Order(value=2)
    @ConditionalOnProperty(name={"soul.timeVerify.enabled"}, matchIfMissing=true)
    public WebFilter timeWebFilter() {
        return new TimeWebFilter();
    }

    @Bean
    @Order(value=2)
    public WebFilter webSocketWebFilter() {
        return new WebSocketWebFilter();
    }

    @Bean
    @ConditionalOnMissingBean(value={GenericParamService.class}, search=SearchStrategy.ALL)
    public GenericParamService genericParamService() {
        return new GenericParamServiceImpl();
    }

    @Bean
    public ReactorNettyWebSocketClient reactorNettyWebSocketClient() {
        return new ReactorNettyWebSocketClient();
    }

    @Bean
    public WebSocketService webSocketService() {
        return new HandshakeWebSocketService();
    }
}

