/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.config;

import org.dromara.soul.web.cache.ZookeeperCacheManager;
import org.dromara.soul.web.plugin.SoulPlugin;
import org.dromara.soul.web.plugin.function.SpringCloudPlugin;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.netflix.ribbon.RibbonAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.reactive.DispatcherHandler;

@Configuration
@ConditionalOnClass(value={LoadBalancerClient.class, RibbonAutoConfiguration.class, DispatcherHandler.class})
@AutoConfigureAfter(value={RibbonAutoConfiguration.class})
@ConditionalOnProperty(prefix="eureka.client.serviceUrl", name={"defaultZone"})
@EnableDiscoveryClient
public class SpringCloudAutoConfiguration {
    private final LoadBalancerClient loadBalancerClient;
    private final ZookeeperCacheManager zookeeperCacheManager;

    @Autowired(required=false)
    public SpringCloudAutoConfiguration(LoadBalancerClient loadBalancerClient, ZookeeperCacheManager zookeeperCacheManager) {
        this.loadBalancerClient = loadBalancerClient;
        this.zookeeperCacheManager = zookeeperCacheManager;
    }

    @Bean
    public SoulPlugin springCloudPlugin() {
        return new SpringCloudPlugin(this.zookeeperCacheManager, this.loadBalancerClient);
    }
}

