/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.filter;

import java.util.Map;
import org.dromara.soul.common.enums.RpcTypeEnum;
import org.dromara.soul.common.utils.GsonUtils;
import org.dromara.soul.web.filter.DefaultServerRequest;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class BodyWebFilter
implements WebFilter {
    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        DefaultServerRequest serverRequest = new DefaultServerRequest(exchange);
        ServerHttpRequest request = exchange.getRequest();
        String rpcType = request.getHeaders().getFirst("rpcType");
        if (RpcTypeEnum.DUBBO.getName().equals(rpcType)) {
            MediaType mediaType = request.getHeaders().getContentType();
            return serverRequest.bodyToMono(String.class).flatMap(body -> {
                if (MediaType.APPLICATION_JSON.isCompatibleWith(mediaType)) {
                    Map paramMap = GsonUtils.getInstance().toObjectMap(body);
                    exchange.getAttributes().put("dubbo_params", paramMap);
                }
                return chain.filter(exchange);
            });
        }
        return chain.filter(exchange);
    }
}

