/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.filter;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.dromara.soul.common.enums.RpcTypeEnum;
import org.dromara.soul.common.result.SoulResult;
import org.dromara.soul.common.utils.GsonUtils;
import org.dromara.soul.web.filter.AbstractWebFilter;
import org.dromara.soul.web.request.RequestDTO;
import org.reactivestreams.Publisher;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class WebSocketWebFilter
extends AbstractWebFilter {
    @Override
    protected Mono<Boolean> doFilter(ServerWebExchange exchange, WebFilterChain chain) {
        ServerHttpRequest request = exchange.getRequest();
        HttpHeaders headers = request.getHeaders();
        String upgrade = headers.getFirst("Upgrade");
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{upgrade}) && RpcTypeEnum.WEB_SOCKET.getName().equals(upgrade)) {
            MultiValueMap queryParams = request.getQueryParams();
            RequestDTO requestDTO = RequestDTO.transformMap((MultiValueMap<String, String>)queryParams);
            if (this.verify(requestDTO).booleanValue()) {
                exchange.getAttributes().put("requestDTO", requestDTO);
            } else {
                return Mono.just((Object)false);
            }
        }
        return Mono.just((Object)true);
    }

    @Override
    protected Mono<Void> doDenyResponse(ServerWebExchange exchange) {
        ServerHttpResponse response = exchange.getResponse();
        response.setStatusCode(HttpStatus.INTERNAL_SERVER_ERROR);
        SoulResult result = SoulResult.error((String)"you param is error please check with doc!");
        return response.writeWith((Publisher)Mono.just((Object)response.bufferFactory().wrap(GsonUtils.getInstance().toJson((Object)result).getBytes())));
    }

    private Boolean verify(RequestDTO requestDTO) {
        return !Objects.isNull(requestDTO) && !StringUtils.isBlank((CharSequence)requestDTO.getModule()) && !StringUtils.isBlank((CharSequence)requestDTO.getMethod()) && !StringUtils.isBlank((CharSequence)requestDTO.getRpcType());
    }
}

