/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.handler;

import java.util.List;
import org.dromara.soul.web.plugin.SoulPlugin;
import org.dromara.soul.web.plugin.SoulPluginChain;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebHandler;
import reactor.core.publisher.Mono;

public final class SoulWebHandler
implements WebHandler {
    private List<SoulPlugin> plugins;

    public SoulWebHandler(List<SoulPlugin> plugins) {
        this.plugins = plugins;
    }

    public Mono<Void> handle(ServerWebExchange exchange) {
        return new DefaultSoulPluginChain(this.plugins).execute(exchange).doOnError(Throwable::printStackTrace);
    }

    private static class DefaultSoulPluginChain
    implements SoulPluginChain {
        private int index;
        private final List<SoulPlugin> plugins;

        DefaultSoulPluginChain(List<SoulPlugin> plugins) {
            this.plugins = plugins;
        }

        @Override
        public Mono<Void> execute(ServerWebExchange exchange) {
            if (this.index < this.plugins.size()) {
                SoulPlugin plugin = this.plugins.get(this.index++);
                return plugin.execute(exchange, this);
            }
            return Mono.empty();
        }
    }
}

