/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.influxdb.service;

import java.util.concurrent.TimeUnit;
import org.dromara.soul.web.influxdb.entity.MonitorDO;
import org.influxdb.dto.Point;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.influxdb.InfluxDBTemplate;
import org.springframework.stereotype.Component;

@Component
public class InfluxDbService {
    private final InfluxDBTemplate influxDBTemplate;

    @Autowired
    public InfluxDbService(InfluxDBTemplate influxDBTemplate) {
        this.influxDBTemplate = influxDBTemplate;
    }

    public void writeData(MonitorDO monitorDO) {
        Point.Builder builder = Point.measurement((String)"monitorDO").time(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        builder.tag("host", monitorDO.getHost()).tag("ip", monitorDO.getIp()).tag("method", monitorDO.getMethod()).tag("module", monitorDO.getModule()).tag("resultType", monitorDO.getResultType()).tag("rpcType", monitorDO.getRpcType()).addField("count", (Number)monitorDO.getCount());
        Point point = builder.build();
        this.influxDBTemplate.write(new Object[]{point});
    }
}

