/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.plugin;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.dromara.soul.common.dto.zk.PluginZkDTO;
import org.dromara.soul.common.dto.zk.RuleZkDTO;
import org.dromara.soul.common.dto.zk.SelectorZkDTO;
import org.dromara.soul.common.enums.PluginEnum;
import org.dromara.soul.common.enums.SelectorTypeEnum;
import org.dromara.soul.common.result.SoulResult;
import org.dromara.soul.common.utils.JsonUtils;
import org.dromara.soul.common.utils.LogUtils;
import org.dromara.soul.web.cache.ZookeeperCacheManager;
import org.dromara.soul.web.condition.strategy.MatchStrategyFactory;
import org.dromara.soul.web.plugin.SoulPlugin;
import org.dromara.soul.web.plugin.SoulPluginChain;
import org.dromara.soul.web.request.RequestDTO;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public abstract class AbstractSoulPlugin
implements SoulPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSoulPlugin.class);
    private final ZookeeperCacheManager zookeeperCacheManager;

    protected abstract Mono<Void> doExecute(ServerWebExchange var1, SoulPluginChain var2, SelectorZkDTO var3, RuleZkDTO var4);

    @Override
    public Mono<Void> execute(ServerWebExchange exchange, SoulPluginChain chain) {
        PluginZkDTO pluginZkDTO = this.zookeeperCacheManager.findPluginByName(this.named());
        if (!this.skip(exchange).booleanValue() && pluginZkDTO != null && pluginZkDTO.getEnabled().booleanValue()) {
            List<RuleZkDTO> rules;
            List<SelectorZkDTO> selectors = this.zookeeperCacheManager.findSelectorByPluginName(this.named());
            if (CollectionUtils.isEmpty(selectors)) {
                return chain.execute(exchange);
            }
            SelectorZkDTO selectorZkDTO = selectors.stream().filter(selector -> selector.getEnabled() != false && this.filterSelector((SelectorZkDTO)selector, exchange) != false).findFirst().orElse(null);
            if (Objects.isNull(selectorZkDTO)) {
                return chain.execute(exchange);
            }
            if (selectorZkDTO.getLoged().booleanValue()) {
                LogUtils.info((Logger)LOGGER, (String)(this.named() + " selector success selector name :{}"), () -> ((SelectorZkDTO)selectorZkDTO).getName());
            }
            if (CollectionUtils.isEmpty(rules = this.zookeeperCacheManager.findRuleBySelectorId(selectorZkDTO.getId()))) {
                return chain.execute(exchange);
            }
            RuleZkDTO rule = this.filterRule(exchange, rules);
            RequestDTO request = (RequestDTO)exchange.getAttribute("requestDTO");
            if (Objects.isNull(rule)) {
                if (PluginEnum.DIVIDE.getName().equals(this.named()) || PluginEnum.DUBBO.getName().equals(this.named()) || PluginEnum.SPRING_CLOUD.getName().equals(this.named())) {
                    LogUtils.info((Logger)LOGGER, () -> Objects.requireNonNull(request).getModule() + ":" + request.getMethod() + " not match  " + this.named() + "  rule");
                    SoulResult error = SoulResult.error((int)HttpStatus.NOT_FOUND.value(), (String)"this can not rule upstream please check you config!");
                    return exchange.getResponse().writeWith((Publisher)Mono.just((Object)exchange.getResponse().bufferFactory().wrap(Objects.requireNonNull(JsonUtils.toJson((Object)error)).getBytes())));
                }
                return chain.execute(exchange);
            }
            if (rule.getLoged().booleanValue()) {
                LogUtils.info((Logger)LOGGER, () -> Objects.requireNonNull(request).getModule() + ":" + request.getMethod() + " match " + this.named() + " rule is name :" + rule.getName());
            }
            return this.doExecute(exchange, chain, selectorZkDTO, rule);
        }
        return chain.execute(exchange);
    }

    private Boolean filterSelector(SelectorZkDTO selector, ServerWebExchange exchange) {
        if (selector.getType().intValue() == SelectorTypeEnum.CUSTOM_FLOW.getCode()) {
            if (CollectionUtils.isEmpty((Collection)selector.getConditionZkDTOList())) {
                return false;
            }
            return MatchStrategyFactory.of(selector.getMatchMode()).match(selector.getConditionZkDTOList(), exchange);
        }
        return true;
    }

    private RuleZkDTO filterRule(ServerWebExchange exchange, List<RuleZkDTO> rules) {
        return rules.stream().filter(rule -> Objects.nonNull(rule) && rule.getEnabled() != false).filter(ruleZkDTO -> MatchStrategyFactory.of(ruleZkDTO.getMatchMode()).match(ruleZkDTO.getConditionZkDTOList(), exchange)).findFirst().orElse(null);
    }

    public AbstractSoulPlugin(ZookeeperCacheManager zookeeperCacheManager) {
        this.zookeeperCacheManager = zookeeperCacheManager;
    }
}

