/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.plugin.after;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.dromara.soul.common.dto.zk.RuleZkDTO;
import org.dromara.soul.common.dto.zk.SelectorZkDTO;
import org.dromara.soul.common.enums.PluginEnum;
import org.dromara.soul.common.enums.PluginTypeEnum;
import org.dromara.soul.common.enums.ResultEnum;
import org.dromara.soul.web.cache.ZookeeperCacheManager;
import org.dromara.soul.web.disruptor.publisher.SoulEventPublisher;
import org.dromara.soul.web.influxdb.entity.MonitorDO;
import org.dromara.soul.web.plugin.AbstractSoulPlugin;
import org.dromara.soul.web.plugin.SoulPluginChain;
import org.dromara.soul.web.request.RequestDTO;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class MonitorPlugin
extends AbstractSoulPlugin {
    private final SoulEventPublisher soulEventPublisher;

    public MonitorPlugin(SoulEventPublisher soulEventPublisher, ZookeeperCacheManager zookeeperCacheManager) {
        super(zookeeperCacheManager);
        this.soulEventPublisher = soulEventPublisher;
    }

    @Override
    protected Mono<Void> doExecute(ServerWebExchange exchange, SoulPluginChain chain, SelectorZkDTO selector, RuleZkDTO rule) {
        this.soulEventPublisher.publishEvent(this.buildMonitorData(exchange));
        return chain.execute(exchange);
    }

    @Override
    public String named() {
        return PluginEnum.MONITOR.getName();
    }

    @Override
    public int getOrder() {
        return PluginEnum.MONITOR.getCode();
    }

    private MonitorDO buildMonitorData(ServerWebExchange exchange) {
        RequestDTO requestDTO = (RequestDTO)exchange.getAttribute("requestDTO");
        MonitorDO visitorDO = new MonitorDO();
        String result = (String)exchange.getAttribute("webHandlerClientResponseResultType");
        if (StringUtils.isBlank((CharSequence)result)) {
            visitorDO.setResultType(ResultEnum.ERROR.getName());
        } else {
            visitorDO.setResultType(result);
        }
        visitorDO.setRpcType(Objects.requireNonNull(requestDTO).getRpcType());
        visitorDO.setCount(1);
        visitorDO.setModule(requestDTO.getModule());
        visitorDO.setMethod(requestDTO.getMethod());
        visitorDO.setIp(Objects.requireNonNull(exchange.getRequest().getRemoteAddress()).getAddress().getHostAddress());
        visitorDO.setHost(exchange.getRequest().getRemoteAddress().getHostString());
        return visitorDO;
    }

    @Override
    public PluginTypeEnum pluginType() {
        return PluginTypeEnum.LAST;
    }
}

