/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.plugin.dubbo;

import com.alibaba.dubbo.config.ApplicationConfig;
import com.alibaba.dubbo.config.ReferenceConfig;
import com.alibaba.dubbo.config.RegistryConfig;
import com.alibaba.dubbo.config.utils.ReferenceConfigCache;
import com.alibaba.dubbo.rpc.service.GenericException;
import com.alibaba.dubbo.rpc.service.GenericService;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.dromara.soul.common.dto.convert.rule.DubboRuleHandle;
import org.dromara.soul.common.dto.convert.selector.DubboSelectorHandle;
import org.dromara.soul.common.enums.LoadBalanceEnum;
import org.dromara.soul.common.exception.SoulException;
import org.dromara.soul.common.utils.LogUtils;
import org.dromara.soul.web.plugin.dubbo.GenericParamService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DubboProxyService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DubboProxyService.class);
    private static final Map<String, RegistryConfig> REGISTRY_CONFIG_MAP = Maps.newConcurrentMap();
    private static final Map<String, ApplicationConfig> APPLICATION_CONFIG_MAP = Maps.newConcurrentMap();
    private final GenericParamService genericParamService;

    @Autowired(required=false)
    public DubboProxyService(GenericParamService genericParamService) {
        this.genericParamService = genericParamService;
    }

    public Object genericInvoker(Map<String, Object> paramMap, DubboSelectorHandle dubboSelectorHandle, DubboRuleHandle dubboRuleHandle) throws SoulException {
        GenericService genericService;
        ReferenceConfig<GenericService> reference = this.buildReferenceConfig(dubboSelectorHandle, dubboRuleHandle, paramMap.get("interfaceName").toString());
        ReferenceConfigCache referenceConfigCache = ReferenceConfigCache.getCache();
        try {
            genericService = (GenericService)referenceConfigCache.get(reference);
        }
        catch (NullPointerException ex) {
            referenceConfigCache.destroy(reference);
            LogUtils.error((Logger)LOGGER, ex::getMessage);
            throw new SoulException(ex.getMessage());
        }
        String method = paramMap.get("method").toString();
        Pair<String[], Object[]> pair = this.genericParamService.buildParameter(paramMap);
        try {
            return genericService.$invoke(method, (String[])pair.getLeft(), (Object[])pair.getRight());
        }
        catch (GenericException e) {
            LogUtils.error((Logger)LOGGER, () -> ((GenericException)e).getExceptionMessage());
            throw new SoulException(e.getMessage());
        }
    }

    private ReferenceConfig<GenericService> buildReferenceConfig(DubboSelectorHandle dubboSelectorHandle, DubboRuleHandle dubboRuleHandle, String interfaceName) {
        ReferenceConfig reference = new ReferenceConfig();
        reference.setGeneric(Boolean.valueOf(true));
        ApplicationConfig applicationConfig = this.cacheApplication(dubboSelectorHandle.getAppName());
        reference.setApplication(applicationConfig);
        reference.setRegistry(this.cacheRegistry(dubboSelectorHandle.getAppName(), dubboSelectorHandle.getRegistry()));
        reference.setInterface(interfaceName);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dubboSelectorHandle.getProtocol()})) {
            reference.setProtocol(dubboSelectorHandle.getProtocol());
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dubboRuleHandle.getVersion()})) {
            reference.setVersion(dubboRuleHandle.getVersion());
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dubboRuleHandle.getGroup()})) {
            reference.setGroup(dubboRuleHandle.getGroup());
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dubboRuleHandle.getLoadBalance()})) {
            String loadBalance = dubboRuleHandle.getLoadBalance();
            if (LoadBalanceEnum.HASH.getName().equals(loadBalance)) {
                reference.setLoadbalance("consistenthash");
            } else if (LoadBalanceEnum.ROUND_ROBIN.getName().equals(loadBalance)) {
                reference.setLoadbalance("roundrobin");
            } else {
                reference.setLoadbalance(loadBalance);
            }
        }
        Optional.ofNullable(dubboRuleHandle.getTimeout()).ifPresent(arg_0 -> ((ReferenceConfig)reference).setTimeout(arg_0));
        Optional.ofNullable(dubboRuleHandle.getRetries()).ifPresent(arg_0 -> ((ReferenceConfig)reference).setRetries(arg_0));
        return reference;
    }

    private ApplicationConfig cacheApplication(String appName) {
        ApplicationConfig applicationConfig = APPLICATION_CONFIG_MAP.get(appName);
        if (Objects.isNull(applicationConfig)) {
            applicationConfig = new ApplicationConfig(appName);
            APPLICATION_CONFIG_MAP.put(appName, applicationConfig);
        }
        return applicationConfig;
    }

    private RegistryConfig cacheRegistry(String appName, String registry) {
        RegistryConfig registryConfig = REGISTRY_CONFIG_MAP.get(appName);
        if (Objects.isNull(registryConfig)) {
            registryConfig = new RegistryConfig(registry);
            REGISTRY_CONFIG_MAP.put(appName, registryConfig);
        }
        return registryConfig;
    }
}

