/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.plugin.function;

import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.dromara.soul.common.dto.convert.DivideUpstream;
import org.dromara.soul.common.dto.convert.HystrixHandle;
import org.dromara.soul.common.dto.convert.rule.DivideRuleHandle;
import org.dromara.soul.common.dto.zk.RuleZkDTO;
import org.dromara.soul.common.dto.zk.SelectorZkDTO;
import org.dromara.soul.common.enums.PluginEnum;
import org.dromara.soul.common.enums.PluginTypeEnum;
import org.dromara.soul.common.enums.ResultEnum;
import org.dromara.soul.common.enums.RpcTypeEnum;
import org.dromara.soul.common.utils.GsonUtils;
import org.dromara.soul.common.utils.LogUtils;
import org.dromara.soul.web.balance.utils.LoadBalanceUtils;
import org.dromara.soul.web.cache.UpstreamCacheManager;
import org.dromara.soul.web.cache.ZookeeperCacheManager;
import org.dromara.soul.web.plugin.AbstractSoulPlugin;
import org.dromara.soul.web.plugin.SoulPluginChain;
import org.dromara.soul.web.plugin.hystrix.HttpCommand;
import org.dromara.soul.web.plugin.hystrix.HystrixBuilder;
import org.dromara.soul.web.request.RequestDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import rx.Subscription;

public class DividePlugin
extends AbstractSoulPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(DividePlugin.class);
    private final UpstreamCacheManager upstreamCacheManager;

    public DividePlugin(ZookeeperCacheManager zookeeperCacheManager, UpstreamCacheManager upstreamCacheManager) {
        super(zookeeperCacheManager);
        this.upstreamCacheManager = upstreamCacheManager;
    }

    @Override
    protected Mono<Void> doExecute(ServerWebExchange exchange, SoulPluginChain chain, SelectorZkDTO selector, RuleZkDTO rule) {
        List<DivideUpstream> upstreamList;
        RequestDTO requestDTO = (RequestDTO)exchange.getAttribute("requestDTO");
        DivideRuleHandle ruleHandle = (DivideRuleHandle)GsonUtils.getInstance().fromJson(rule.getHandle(), DivideRuleHandle.class);
        if (StringUtils.isBlank((CharSequence)ruleHandle.getGroupKey())) {
            ruleHandle.setGroupKey(Objects.requireNonNull(requestDTO).getModule());
        }
        if (StringUtils.isBlank((CharSequence)ruleHandle.getCommandKey())) {
            ruleHandle.setCommandKey(Objects.requireNonNull(requestDTO).getMethod());
        }
        if (CollectionUtils.isEmpty(upstreamList = this.upstreamCacheManager.findUpstreamListBySelectorId(selector.getId()))) {
            LogUtils.error((Logger)LOGGER, (String)"divide upstream config error\uff1a{}", () -> ((RuleZkDTO)rule).toString());
            return chain.execute(exchange);
        }
        String ip = Objects.requireNonNull(exchange.getRequest().getRemoteAddress()).getAddress().getHostAddress();
        DivideUpstream divideUpstream = LoadBalanceUtils.selector(upstreamList, ruleHandle.getLoadBalance(), ip);
        if (Objects.isNull(divideUpstream)) {
            LogUtils.error((Logger)LOGGER, () -> "LoadBalance has error\uff01");
            return chain.execute(exchange);
        }
        HttpCommand command = new HttpCommand(HystrixBuilder.build((HystrixHandle)ruleHandle), exchange, chain, requestDTO, this.buildRealURL(divideUpstream), ruleHandle.getTimeout());
        return Mono.create(s -> {
            Subscription sub = command.toObservable().subscribe(arg_0 -> ((MonoSink)s).success(arg_0), arg_0 -> ((MonoSink)s).error(arg_0), () -> ((MonoSink)s).success());
            s.onCancel(() -> ((Subscription)sub).unsubscribe());
            if (command.isCircuitBreakerOpen()) {
                LogUtils.error((Logger)LOGGER, () -> ruleHandle.getGroupKey() + "....http:circuitBreaker is Open.... !");
            }
        }).doOnError(throwable -> {
            throwable.printStackTrace();
            exchange.getAttributes().put("webHandlerClientResponseResultType", ResultEnum.ERROR.getName());
            chain.execute(exchange);
        }).then();
    }

    private String buildRealURL(DivideUpstream divideUpstream) {
        String protocol = divideUpstream.getProtocol();
        if (StringUtils.isBlank((CharSequence)protocol)) {
            protocol = "http://";
        }
        return protocol + divideUpstream.getUpstreamUrl().trim();
    }

    @Override
    public String named() {
        return PluginEnum.DIVIDE.getName();
    }

    @Override
    public Boolean skip(ServerWebExchange exchange) {
        RequestDTO body = (RequestDTO)exchange.getAttribute("requestDTO");
        return !Objects.equals(Objects.requireNonNull(body).getRpcType(), RpcTypeEnum.HTTP.getName());
    }

    @Override
    public PluginTypeEnum pluginType() {
        return PluginTypeEnum.FUNCTION;
    }

    @Override
    public int getOrder() {
        return PluginEnum.DIVIDE.getCode();
    }
}

