/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.plugin.function;

import java.util.Objects;
import org.dromara.soul.common.dto.convert.RateLimiterHandle;
import org.dromara.soul.common.dto.zk.RuleZkDTO;
import org.dromara.soul.common.dto.zk.SelectorZkDTO;
import org.dromara.soul.common.enums.PluginEnum;
import org.dromara.soul.common.enums.PluginTypeEnum;
import org.dromara.soul.common.result.SoulResult;
import org.dromara.soul.common.utils.GsonUtils;
import org.dromara.soul.common.utils.JsonUtils;
import org.dromara.soul.web.cache.ZookeeperCacheManager;
import org.dromara.soul.web.plugin.AbstractSoulPlugin;
import org.dromara.soul.web.plugin.SoulPluginChain;
import org.dromara.soul.web.plugin.ratelimter.RedisRateLimiter;
import org.reactivestreams.Publisher;
import org.springframework.http.HttpStatus;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class RateLimiterPlugin
extends AbstractSoulPlugin {
    private final RedisRateLimiter redisRateLimiter;

    public RateLimiterPlugin(ZookeeperCacheManager zookeeperCacheManager, RedisRateLimiter redisRateLimiter) {
        super(zookeeperCacheManager);
        this.redisRateLimiter = redisRateLimiter;
    }

    @Override
    public String named() {
        return PluginEnum.RATE_LIMITER.getName();
    }

    @Override
    public PluginTypeEnum pluginType() {
        return PluginTypeEnum.FUNCTION;
    }

    @Override
    public int getOrder() {
        return PluginEnum.RATE_LIMITER.getCode();
    }

    @Override
    protected Mono<Void> doExecute(ServerWebExchange exchange, SoulPluginChain chain, SelectorZkDTO selector, RuleZkDTO rule) {
        String handle = rule.getHandle();
        RateLimiterHandle limiterHandle = (RateLimiterHandle)GsonUtils.getInstance().fromJson(handle, RateLimiterHandle.class);
        return this.redisRateLimiter.isAllowed(rule.getId(), limiterHandle.getReplenishRate(), limiterHandle.getBurstCapacity()).flatMap(response -> {
            if (!response.isAllowed()) {
                exchange.getResponse().setStatusCode(HttpStatus.TOO_MANY_REQUESTS);
                return exchange.getResponse().writeWith((Publisher)Mono.just((Object)exchange.getResponse().bufferFactory().wrap(Objects.requireNonNull(JsonUtils.toJson((Object)SoulResult.error((String)"the request is too fast please try again later"))).getBytes())));
            }
            return chain.execute(exchange);
        });
    }
}

