/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.plugin.function;

import java.net.URI;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.dromara.soul.common.dto.convert.HystrixHandle;
import org.dromara.soul.common.dto.convert.rule.SpringCloudRuleHandle;
import org.dromara.soul.common.dto.zk.RuleZkDTO;
import org.dromara.soul.common.dto.zk.SelectorZkDTO;
import org.dromara.soul.common.enums.PluginEnum;
import org.dromara.soul.common.enums.PluginTypeEnum;
import org.dromara.soul.common.enums.ResultEnum;
import org.dromara.soul.common.enums.RpcTypeEnum;
import org.dromara.soul.common.utils.GsonUtils;
import org.dromara.soul.common.utils.LogUtils;
import org.dromara.soul.web.cache.ZookeeperCacheManager;
import org.dromara.soul.web.plugin.AbstractSoulPlugin;
import org.dromara.soul.web.plugin.SoulPluginChain;
import org.dromara.soul.web.plugin.hystrix.HttpCommand;
import org.dromara.soul.web.plugin.hystrix.HystrixBuilder;
import org.dromara.soul.web.request.RequestDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import rx.Subscription;

public class SpringCloudPlugin
extends AbstractSoulPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringCloudPlugin.class);
    private final LoadBalancerClient loadBalancer;

    public SpringCloudPlugin(ZookeeperCacheManager zookeeperCacheManager, LoadBalancerClient loadBalancer) {
        super(zookeeperCacheManager);
        this.loadBalancer = loadBalancer;
    }

    @Override
    protected Mono<Void> doExecute(ServerWebExchange exchange, SoulPluginChain chain, SelectorZkDTO selector, RuleZkDTO rule) {
        if (Objects.isNull(rule)) {
            return Mono.empty();
        }
        RequestDTO requestDTO = (RequestDTO)exchange.getAttribute("requestDTO");
        assert (requestDTO != null);
        SpringCloudRuleHandle ruleHandle = (SpringCloudRuleHandle)GsonUtils.getInstance().fromJson(rule.getHandle(), SpringCloudRuleHandle.class);
        String serviceId = selector.getHandle();
        if (StringUtils.isBlank((String)ruleHandle.getGroupKey())) {
            ruleHandle.setGroupKey(requestDTO.getModule());
        }
        if (StringUtils.isBlank((String)ruleHandle.getCommandKey())) {
            ruleHandle.setCommandKey(requestDTO.getMethod());
        }
        if (StringUtils.isBlank((String)serviceId) || StringUtils.isBlank((String)ruleHandle.getPath())) {
            LogUtils.error((Logger)LOGGER, () -> "can not config spring cloud handle....");
            return Mono.empty();
        }
        ServiceInstance serviceInstance = this.loadBalancer.choose(serviceId);
        if (Objects.isNull(serviceInstance)) {
            LogUtils.error((Logger)LOGGER, () -> "eureka never register this serviceId " + serviceId);
            return Mono.empty();
        }
        URI uri = this.loadBalancer.reconstructURI(serviceInstance, URI.create(ruleHandle.getPath()));
        HttpCommand command = new HttpCommand(HystrixBuilder.build((HystrixHandle)ruleHandle), exchange, chain, requestDTO, uri.toString(), ruleHandle.getTimeout());
        return Mono.create(s -> {
            Subscription sub = command.toObservable().subscribe(arg_0 -> ((MonoSink)s).success(arg_0), arg_0 -> ((MonoSink)s).error(arg_0), () -> ((MonoSink)s).success());
            s.onCancel(() -> ((Subscription)sub).unsubscribe());
            if (command.isCircuitBreakerOpen()) {
                LogUtils.error((Logger)LOGGER, () -> ruleHandle.getGroupKey() + ":spring cloud execute circuitBreaker is Open !");
            }
        }).doOnError(throwable -> {
            throwable.printStackTrace();
            exchange.getAttributes().put("webHandlerClientResponseResultType", ResultEnum.ERROR.getName());
            chain.execute(exchange);
        }).then();
    }

    @Override
    public PluginTypeEnum pluginType() {
        return PluginTypeEnum.FUNCTION;
    }

    @Override
    public int getOrder() {
        return PluginEnum.SPRING_CLOUD.getCode();
    }

    @Override
    public String named() {
        return PluginEnum.SPRING_CLOUD.getName();
    }

    @Override
    public Boolean skip(ServerWebExchange exchange) {
        RequestDTO body = (RequestDTO)exchange.getAttribute("requestDTO");
        return !Objects.equals(Objects.requireNonNull(body).getRpcType(), RpcTypeEnum.SPRING_CLOUD.getName());
    }
}

