/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.plugin.hystrix;

import com.netflix.hystrix.HystrixObservableCommand;
import java.util.Map;
import java.util.Objects;
import org.dromara.soul.common.dto.convert.rule.DubboRuleHandle;
import org.dromara.soul.common.dto.convert.selector.DubboSelectorHandle;
import org.dromara.soul.common.enums.ResultEnum;
import org.dromara.soul.common.result.SoulResult;
import org.dromara.soul.common.utils.JsonUtils;
import org.dromara.soul.common.utils.LogUtils;
import org.dromara.soul.web.plugin.SoulPluginChain;
import org.dromara.soul.web.plugin.dubbo.DubboProxyService;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import rx.Observable;
import rx.RxReactiveStreams;

public class DubboCommand
extends HystrixObservableCommand<Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DubboCommand.class);
    private final ServerWebExchange exchange;
    private final SoulPluginChain chain;
    private final DubboProxyService dubboProxyService;
    private final Map<String, Object> paramMap;
    private final DubboSelectorHandle dubboSelectorHandle;
    private final DubboRuleHandle dubboRuleHandle;

    public DubboCommand(HystrixObservableCommand.Setter setter, Map<String, Object> paramMap, ServerWebExchange exchange, SoulPluginChain chain, DubboProxyService dubboProxyService, DubboSelectorHandle dubboSelectorHandle, DubboRuleHandle dubboRuleHandle) {
        super(setter);
        this.exchange = exchange;
        this.paramMap = paramMap;
        this.chain = chain;
        this.dubboProxyService = dubboProxyService;
        this.dubboSelectorHandle = dubboSelectorHandle;
        this.dubboRuleHandle = dubboRuleHandle;
    }

    protected Observable<Void> construct() {
        return RxReactiveStreams.toObservable(this.doRpcInvoke());
    }

    private Mono<Void> doRpcInvoke() {
        Object result = this.dubboProxyService.genericInvoker(this.paramMap, this.dubboSelectorHandle, this.dubboRuleHandle);
        if (Objects.nonNull(result)) {
            this.exchange.getAttributes().put("dubbo_rpc_result", result);
        } else {
            this.exchange.getAttributes().put("dubbo_rpc_result", "dubbo has not return value!");
        }
        this.exchange.getAttributes().put("webHandlerClientResponseResultType", ResultEnum.SUCCESS.getName());
        return this.chain.execute(this.exchange);
    }

    protected Observable<Void> resumeWithFallback() {
        return RxReactiveStreams.toObservable(this.doFallback());
    }

    private Mono<Void> doFallback() {
        if (this.isFailedExecution()) {
            LogUtils.error((Logger)LOGGER, (String)"dubbo rpc have error:{}", () -> this.getExecutionException().getMessage());
        }
        this.exchange.getResponse().setStatusCode(HttpStatus.INTERNAL_SERVER_ERROR);
        SoulResult error = SoulResult.error((String)"dubbo rpc have error or fuse ing please check your param and  try again later");
        return this.exchange.getResponse().writeWith((Publisher)Mono.just((Object)this.exchange.getResponse().bufferFactory().wrap(Objects.requireNonNull(JsonUtils.toJson((Object)error)).getBytes())));
    }
}

