/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.plugin.hystrix;

import com.netflix.hystrix.HystrixObservableCommand;
import com.netflix.hystrix.exception.HystrixRuntimeException;
import com.netflix.hystrix.exception.HystrixTimeoutException;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.dromara.soul.common.enums.HttpMethodEnum;
import org.dromara.soul.common.enums.ResultEnum;
import org.dromara.soul.common.result.SoulResult;
import org.dromara.soul.common.utils.GsonUtils;
import org.dromara.soul.common.utils.JsonUtils;
import org.dromara.soul.common.utils.LogUtils;
import org.dromara.soul.web.plugin.SoulPluginChain;
import org.dromara.soul.web.request.RequestDTO;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import rx.Observable;
import rx.RxReactiveStreams;

public class HttpCommand
extends HystrixObservableCommand<Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpCommand.class);
    private static final WebClient WEB_CLIENT = WebClient.create();
    private final ServerWebExchange exchange;
    private final SoulPluginChain chain;
    private final RequestDTO requestDTO;
    private final String url;
    private final Integer timeout;

    public HttpCommand(HystrixObservableCommand.Setter setter, ServerWebExchange exchange, SoulPluginChain chain, RequestDTO requestDTO, String url, Integer timeout) {
        super(setter);
        this.exchange = exchange;
        this.chain = chain;
        this.requestDTO = requestDTO;
        this.url = url;
        this.timeout = timeout;
    }

    protected Observable<Void> construct() {
        return RxReactiveStreams.toObservable(this.doHttpInvoke());
    }

    private Mono<Void> doHttpInvoke() {
        if (this.requestDTO.getHttpMethod().equals(HttpMethodEnum.GET.getName())) {
            String uri = this.getUrl(this.buildRealURL());
            LogUtils.debug((Logger)LOGGER, (String)"you get request,The resulting url is :{}", () -> uri);
            return WEB_CLIENT.get().uri(uri, new Object[0]).headers(httpHeaders -> {
                httpHeaders.addAll((MultiValueMap)this.exchange.getRequest().getHeaders());
                httpHeaders.remove((Object)"Host");
            }).exchange().doOnError(e -> LogUtils.error((Logger)LOGGER, e::getMessage)).timeout(Duration.ofMillis(this.timeout.intValue())).flatMap(this::doNext);
        }
        if (this.requestDTO.getHttpMethod().equals(HttpMethodEnum.PUT.getName())) {
            String pathVariable = this.pathVariable(this.buildRealURL());
            LogUtils.debug((Logger)LOGGER, (String)"you put request,The resulting url is :{}", () -> pathVariable);
            return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)WEB_CLIENT.put().uri(pathVariable, new Object[0])).headers(httpHeaders -> {
                httpHeaders.addAll((MultiValueMap)this.exchange.getRequest().getHeaders());
                httpHeaders.remove((Object)"Host");
            })).contentType(this.buildMediaType()).body(BodyInserters.fromDataBuffers((Publisher)this.exchange.getRequest().getBody())).exchange().doOnError(e -> LogUtils.error((Logger)LOGGER, e::getMessage)).timeout(Duration.ofMillis(this.timeout.intValue())).flatMap(this::doNext);
        }
        if (this.requestDTO.getHttpMethod().equals(HttpMethodEnum.DELETE.getName())) {
            String pathVariable = this.pathVariable(this.buildRealURL());
            LogUtils.debug((Logger)LOGGER, (String)"you delete request,The resulting url is:{}", () -> pathVariable);
            return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)WEB_CLIENT.method(HttpMethod.DELETE).uri(pathVariable, new Object[0])).headers(httpHeaders -> {
                httpHeaders.addAll((MultiValueMap)this.exchange.getRequest().getHeaders());
                httpHeaders.remove((Object)"Host");
            })).contentType(this.buildMediaType()).body(BodyInserters.fromDataBuffers((Publisher)this.exchange.getRequest().getBody())).exchange().doOnError(e -> LogUtils.error((Logger)LOGGER, e::getMessage)).timeout(Duration.ofMillis(this.timeout.intValue())).flatMap(this::doNext);
        }
        if (this.requestDTO.getHttpMethod().equals(HttpMethodEnum.POST.getName())) {
            String uri = this.buildRealURL();
            LogUtils.debug((Logger)LOGGER, (String)"you post request,The resulting url is :{}", () -> uri);
            return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)WEB_CLIENT.post().uri(uri, new Object[0])).headers(httpHeaders -> {
                httpHeaders.addAll((MultiValueMap)this.exchange.getRequest().getHeaders());
                httpHeaders.remove((Object)"Host");
            })).contentType(this.buildMediaType()).body(BodyInserters.fromDataBuffers((Publisher)this.exchange.getRequest().getBody())).exchange().doOnError(e -> LogUtils.error((Logger)LOGGER, e::getMessage)).timeout(Duration.ofMillis(this.timeout.intValue())).flatMap(this::doNext);
        }
        return Mono.empty();
    }

    protected Observable<Void> resumeWithFallback() {
        return RxReactiveStreams.toObservable(this.doFallback());
    }

    private String getUrl(String uri) {
        String url = this.pathVariable(uri);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.requestDTO.getExtInfo()})) {
            url = url + "?" + GsonUtils.getInstance().toGetParam(this.requestDTO.getExtInfo());
        }
        return url;
    }

    private String pathVariable(String uri) {
        String path = uri;
        String pathVariable = this.requestDTO.getPathVariable();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{pathVariable})) {
            path = path + "/" + pathVariable;
        }
        return path;
    }

    private MediaType buildMediaType() {
        return MediaType.valueOf((String)Optional.ofNullable(this.exchange.getRequest().getHeaders().getFirst("Content-Type")).orElse("application/json;charset=UTF-8"));
    }

    private Mono<Void> doNext(ClientResponse res) {
        if (res.statusCode().is2xxSuccessful()) {
            this.exchange.getAttributes().put("webHandlerClientResponseResultType", ResultEnum.SUCCESS.getName());
        } else {
            this.exchange.getAttributes().put("webHandlerClientResponseResultType", ResultEnum.ERROR.getName());
        }
        this.exchange.getAttributes().put("webHandlerClientResponse", res);
        return this.chain.execute(this.exchange);
    }

    private String buildRealURL() {
        String rewriteURI = (String)this.exchange.getAttributes().get("rewrite_uri");
        if (StringUtils.isBlank((CharSequence)rewriteURI)) {
            return String.join((CharSequence)"/", this.url, this.requestDTO.getMethod());
        }
        return String.join((CharSequence)"/", this.url, rewriteURI);
    }

    private Mono<Void> doFallback() {
        Throwable exception;
        if (this.isFailedExecution()) {
            LogUtils.error((Logger)LOGGER, (String)"http execute have error:{}", () -> this.getExecutionException().getMessage());
        }
        if ((exception = this.getExecutionException()) instanceof HystrixRuntimeException) {
            HystrixRuntimeException e = (HystrixRuntimeException)this.getExecutionException();
            if (e.getFailureType() == HystrixRuntimeException.FailureType.TIMEOUT) {
                this.exchange.getResponse().setStatusCode(HttpStatus.GATEWAY_TIMEOUT);
            } else {
                this.exchange.getResponse().setStatusCode(HttpStatus.INTERNAL_SERVER_ERROR);
            }
        } else if (exception instanceof HystrixTimeoutException) {
            this.exchange.getResponse().setStatusCode(HttpStatus.GATEWAY_TIMEOUT);
        }
        this.exchange.getResponse().setStatusCode(HttpStatus.INTERNAL_SERVER_ERROR);
        SoulResult error = SoulResult.error((String)"this is bad request or fuse ing please try again later");
        return this.exchange.getResponse().writeWith((Publisher)Mono.just((Object)this.exchange.getResponse().bufferFactory().wrap(Objects.requireNonNull(JsonUtils.toJson((Object)error)).getBytes())));
    }
}

