/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.balance.spi;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.dromara.soul.common.dto.convert.DivideUpstream;
import org.dromara.soul.common.enums.LoadBalanceEnum;
import org.dromara.soul.common.exception.SoulException;
import org.dromara.soul.web.balance.spi.AbstractLoadBalance;

public class HashLoadBalance
extends AbstractLoadBalance {
    private static final int VIRTUAL_NODE_NUM = 5;

    @Override
    public DivideUpstream doSelect(List<DivideUpstream> upstreamList, String ip) {
        TreeMap<Long, DivideUpstream> treeMap = new TreeMap<Long, DivideUpstream>();
        for (DivideUpstream address : upstreamList) {
            for (int i = 0; i < 5; ++i) {
                long addressHash = HashLoadBalance.hash("SOUL-" + address.getUpstreamUrl() + "-HASH-" + i);
                treeMap.put(addressHash, address);
            }
        }
        long hash = HashLoadBalance.hash(String.valueOf(ip));
        SortedMap lastRing = treeMap.tailMap(hash);
        if (!lastRing.isEmpty()) {
            return (DivideUpstream)lastRing.get(lastRing.firstKey());
        }
        return (DivideUpstream)treeMap.firstEntry().getValue();
    }

    @Override
    public String algorithm() {
        return LoadBalanceEnum.HASH.getName();
    }

    private static long hash(String key) {
        byte[] keyBytes;
        MessageDigest md5;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new SoulException("MD5 not supported", (Throwable)e);
        }
        md5.reset();
        try {
            keyBytes = key.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new SoulException("Unknown string :" + key, (Throwable)e);
        }
        md5.update(keyBytes);
        byte[] digest = md5.digest();
        long hashCode = (long)(digest[3] & 0xFF) << 24 | (long)(digest[2] & 0xFF) << 16 | (long)(digest[1] & 0xFF) << 8 | (long)(digest[0] & 0xFF);
        return hashCode & 0xFFFFFFFFL;
    }
}

