/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.cache;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.dromara.soul.common.dto.AppAuthData;
import org.dromara.soul.common.dto.PluginData;
import org.dromara.soul.common.dto.RuleData;
import org.dromara.soul.common.dto.SelectorData;
import org.dromara.soul.web.cache.LocalCacheManager;
import org.dromara.soul.web.plugin.config.PluginConfigHandler;

public abstract class AbstractLocalCacheManager
implements LocalCacheManager {
    static final ConcurrentMap<String, PluginData> PLUGIN_MAP = Maps.newConcurrentMap();
    static final ConcurrentMap<String, List<SelectorData>> SELECTOR_MAP = Maps.newConcurrentMap();
    static final ConcurrentMap<String, List<RuleData>> RULE_MAP = Maps.newConcurrentMap();
    static final ConcurrentMap<String, AppAuthData> AUTH_MAP = Maps.newConcurrentMap();

    @Override
    public AppAuthData findAuthDataByAppKey(String appKey) {
        return (AppAuthData)AUTH_MAP.get(appKey);
    }

    @Override
    public PluginData findPluginByName(String pluginName) {
        return (PluginData)PLUGIN_MAP.get(pluginName);
    }

    @Override
    public List<SelectorData> findSelectorByPluginName(String pluginName) {
        return (List)SELECTOR_MAP.get(pluginName);
    }

    @Override
    public List<RuleData> findRuleBySelectorId(String selectorId) {
        return (List)RULE_MAP.get(selectorId);
    }

    void configPlugin(List<PluginData> pluginDataList) {
        PluginConfigHandler.INS.initPluginConfig(pluginDataList);
    }
}

