/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.cache;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.apache.commons.collections4.CollectionUtils;
import org.dromara.soul.common.concurrent.SoulThreadFactory;
import org.dromara.soul.common.dto.SelectorData;
import org.dromara.soul.common.dto.convert.DivideUpstream;
import org.dromara.soul.common.utils.GsonUtils;
import org.dromara.soul.common.utils.UrlUtils;
import org.dromara.soul.web.config.SoulConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UpstreamCacheManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpstreamCacheManager.class);
    private static final BlockingQueue<SelectorData> BLOCKING_QUEUE = new LinkedBlockingQueue<SelectorData>(1024);
    private static final int MAX_THREAD = Runtime.getRuntime().availableProcessors() << 1;
    private static final Map<String, List<DivideUpstream>> UPSTREAM_MAP = Maps.newConcurrentMap();
    private static final Map<String, List<DivideUpstream>> SCHEDULED_MAP = Maps.newConcurrentMap();
    private static final Integer DELAY_INIT = 30;
    private final SoulConfig soulConfig;

    @Autowired(required=false)
    public UpstreamCacheManager(SoulConfig soulConfig) {
        this.soulConfig = soulConfig;
    }

    public List<DivideUpstream> findUpstreamListBySelectorId(String selectorId) {
        return UPSTREAM_MAP.get(selectorId);
    }

    static void removeByKey(String key) {
        SCHEDULED_MAP.remove(key);
        UPSTREAM_MAP.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void init() {
        Class<UpstreamCacheManager> clazz = UpstreamCacheManager.class;
        synchronized (UpstreamCacheManager.class) {
            ThreadPoolExecutor executorService = new ThreadPoolExecutor(MAX_THREAD, MAX_THREAD, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), SoulThreadFactory.create((String)"save-upstream-task", (boolean)false));
            for (int i = 0; i < MAX_THREAD; ++i) {
                executorService.execute(new Worker());
            }
            new ScheduledThreadPoolExecutor(MAX_THREAD, SoulThreadFactory.create((String)"scheduled-upstream-task", (boolean)false)).scheduleWithFixedDelay(this::scheduled, DELAY_INIT.intValue(), this.soulConfig.getUpstreamScheduledTime().intValue(), TimeUnit.SECONDS);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    static void submit(SelectorData selectorData) {
        try {
            BLOCKING_QUEUE.put(selectorData);
        }
        catch (InterruptedException e) {
            LOGGER.error(e.getMessage());
        }
    }

    static void clear() {
        SCHEDULED_MAP.clear();
        UPSTREAM_MAP.clear();
    }

    public void execute(SelectorData selectorData) {
        List upstreamList = GsonUtils.getInstance().fromList(selectorData.getHandle(), DivideUpstream.class);
        if (CollectionUtils.isNotEmpty((Collection)upstreamList)) {
            SCHEDULED_MAP.put(selectorData.getId(), upstreamList);
            UPSTREAM_MAP.put(selectorData.getId(), this.check(upstreamList));
        }
    }

    private void scheduled() {
        if (SCHEDULED_MAP.size() > 0) {
            SCHEDULED_MAP.forEach((k, v) -> UPSTREAM_MAP.put((String)k, this.check((List<DivideUpstream>)v)));
        }
    }

    private List<DivideUpstream> check(List<DivideUpstream> upstreamList) {
        ArrayList resultList = Lists.newArrayListWithCapacity((int)upstreamList.size());
        for (DivideUpstream divideUpstream : upstreamList) {
            boolean pass = UrlUtils.checkUrl((String)divideUpstream.getUpstreamUrl());
            if (!pass) continue;
            resultList.add(divideUpstream);
        }
        return resultList;
    }

    class Worker
    implements Runnable {
        Worker() {
        }

        @Override
        public void run() {
            this.runTask();
        }

        private void runTask() {
            while (true) {
                try {
                    while (true) {
                        SelectorData selectorData = (SelectorData)BLOCKING_QUEUE.take();
                        Optional.of(selectorData).ifPresent(UpstreamCacheManager.this::execute);
                    }
                }
                catch (InterruptedException e) {
                    LOGGER.warn("BLOCKING_QUEUE take operation was interrupted.", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }
}

