/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.cache;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.dromara.soul.common.concurrent.SoulThreadFactory;
import org.dromara.soul.common.dto.AppAuthData;
import org.dromara.soul.common.dto.PluginData;
import org.dromara.soul.common.dto.RuleData;
import org.dromara.soul.common.dto.SelectorData;
import org.dromara.soul.common.dto.WebsocketData;
import org.dromara.soul.common.enums.ConfigGroupEnum;
import org.dromara.soul.common.enums.DataEventTypeEnum;
import org.dromara.soul.common.utils.GsonUtils;
import org.dromara.soul.common.utils.LogUtils;
import org.dromara.soul.web.cache.WebsocketCacheHandler;
import org.dromara.soul.web.config.SoulConfig;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebsocketSyncCache
extends WebsocketCacheHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebsocketSyncCache.class);
    private WebSocketClient client;
    private volatile boolean alreadySync = Boolean.FALSE;

    public WebsocketSyncCache(SoulConfig.WebsocketConfig websocketConfig) {
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, SoulThreadFactory.create((String)"websocket-connect", (boolean)true));
        try {
            this.client = new WebSocketClient(new URI(websocketConfig.getUrl())){

                public void onOpen(ServerHandshake serverHandshake) {
                    if (!WebsocketSyncCache.this.alreadySync) {
                        WebsocketSyncCache.this.client.send(DataEventTypeEnum.MYSELF.name());
                        WebsocketSyncCache.this.alreadySync = true;
                    }
                }

                public void onMessage(String result) {
                    try {
                        WebsocketSyncCache.this.handleResult(result);
                    }
                    catch (Exception e) {
                        LOGGER.error("websocket handle data exception :{}", (Throwable)e);
                    }
                }

                public void onClose(int code, String msg, boolean b) {
                    WebsocketSyncCache.this.client.close();
                }

                public void onError(Exception e) {
                    WebsocketSyncCache.this.client.close();
                }
            };
        }
        catch (URISyntaxException e) {
            LOGGER.error("websocket url is error :{}", (Throwable)e);
        }
        try {
            boolean success = this.client.connectBlocking();
            if (success) {
                LogUtils.info((Logger)LOGGER, () -> "websocket connection is successful.....");
            }
        }
        catch (InterruptedException e) {
            LOGGER.info("websocket connection...exception....{}", (Throwable)e);
        }
        executor.scheduleAtFixedRate(() -> {
            try {
                if (this.client != null && this.client.isClosed()) {
                    this.client.reconnectBlocking();
                }
            }
            catch (InterruptedException e) {
                LOGGER.error("websocket connect is error :{}", (Object)e.getMessage());
            }
        }, 10L, 30L, TimeUnit.SECONDS);
    }

    private void handleResult(String result) {
        WebsocketData websocketData = (WebsocketData)GsonUtils.getInstance().fromJson(result, WebsocketData.class);
        ConfigGroupEnum groupEnum = ConfigGroupEnum.acquireByName((String)websocketData.getGroupType());
        String eventType = websocketData.getEventType();
        switch (groupEnum) {
            case PLUGIN: {
                String pluginData = GsonUtils.getInstance().toJson((Object)websocketData.getData());
                List pluginDataList = GsonUtils.getInstance().fromList(pluginData, PluginData.class);
                this.handlePlugin(pluginDataList, eventType);
                break;
            }
            case SELECTOR: {
                String selectorData = GsonUtils.getInstance().toJson((Object)websocketData.getData());
                List selectorDataList = GsonUtils.getInstance().fromList(selectorData, SelectorData.class);
                this.handleSelector(selectorDataList, eventType);
                break;
            }
            case RULE: {
                String ruleData = GsonUtils.getInstance().toJson((Object)websocketData.getData());
                List ruleDataList = GsonUtils.getInstance().fromList(ruleData, RuleData.class);
                this.handleRule(ruleDataList, eventType);
                break;
            }
            case APP_AUTH: {
                String appAuthData = GsonUtils.getInstance().toJson((Object)websocketData.getData());
                List appAuthDataList = GsonUtils.getInstance().fromList(appAuthData, AppAuthData.class);
                this.handleAppAuth(appAuthDataList, eventType);
                break;
            }
        }
    }
}

