/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.condition.strategy;

import com.google.common.collect.Maps;
import java.util.Map;
import org.dromara.soul.common.enums.MatchModeEnum;
import org.dromara.soul.web.condition.strategy.AndMatchStrategy;
import org.dromara.soul.web.condition.strategy.MatchStrategy;
import org.dromara.soul.web.condition.strategy.OrMatchStrategy;

public class MatchStrategyFactory {
    private static final Map<Integer, MatchStrategy> MATCH_STRATEGY_MAP = Maps.newHashMapWithExpectedSize((int)2);

    public static MatchStrategy of(Integer strategy) {
        return MATCH_STRATEGY_MAP.get(strategy);
    }

    static {
        MATCH_STRATEGY_MAP.put(MatchModeEnum.AND.getCode(), new AndMatchStrategy());
        MATCH_STRATEGY_MAP.put(MatchModeEnum.OR.getCode(), new OrMatchStrategy());
    }
}

