/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.configuration;

import org.I0Itec.zkclient.ZkClient;
import org.dromara.soul.configuration.zookeeper.ZookeeperConfiguration;
import org.dromara.soul.web.cache.HttpLongPollSyncCache;
import org.dromara.soul.web.cache.LocalCacheManager;
import org.dromara.soul.web.cache.WebsocketSyncCache;
import org.dromara.soul.web.cache.ZookeeperSyncCache;
import org.dromara.soul.web.config.SoulConfig;
import org.dromara.soul.web.configuration.SoulConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@AutoConfigureBefore(value={SoulConfiguration.class})
public class LocalCacheConfiguration {

    @Configuration
    @ConditionalOnMissingBean(value={LocalCacheManager.class})
    @ConditionalOnProperty(name={"soul.sync.strategy"}, havingValue="websocket")
    static class WebsocketCacheManager {
        WebsocketCacheManager() {
        }

        @ConfigurationProperties(prefix="soul.sync.websocket")
        @Bean
        public SoulConfig.WebsocketConfig httpConfig() {
            return new SoulConfig.WebsocketConfig();
        }

        @Bean
        public LocalCacheManager localCacheManager(SoulConfig.WebsocketConfig websocketConfig) {
            return new WebsocketSyncCache(websocketConfig);
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={LocalCacheManager.class})
    @ConditionalOnProperty(name={"soul.sync.strategy"}, havingValue="http", matchIfMissing=true)
    static class HttpCacheManager {
        HttpCacheManager() {
        }

        @ConfigurationProperties(prefix="soul.sync.http")
        @Bean
        public SoulConfig.HttpConfig httpConfig() {
            return new SoulConfig.HttpConfig();
        }

        @Bean
        public LocalCacheManager localCacheManager(SoulConfig.HttpConfig httpConfig) {
            return new HttpLongPollSyncCache(httpConfig);
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={LocalCacheManager.class})
    @ConditionalOnProperty(name={"soul.sync.strategy"}, havingValue="zookeeper")
    @Import(value={ZookeeperConfiguration.class})
    static class ZookeeperCacheManager {
        ZookeeperCacheManager() {
        }

        @Bean
        public LocalCacheManager localCacheManager(ZkClient zkClient) {
            return new ZookeeperSyncCache(zkClient);
        }
    }
}

